% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{predict_prob}
\alias{predict_prob}
\title{Estimation of Failure Probabilities for Parametric Lifetime Distributions}
\usage{
predict_prob(q, loc_sc_params, distribution = c("weibull", "lognormal",
  "loglogistic"))
}
\arguments{
\item{q}{a numeric vector which consists of lifetime data.}

\item{loc_sc_params}{a (named) numeric vector of estimated location
and scale parameters for a specified distribution. The order of
elements is important. First entry needs to be the location
parameter \eqn{\mu} and the second element needs to be the scale
parameter \eqn{\sigma}.}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}.
Other distributions have not been implemented yet.}
}
\value{
A vector containing the estimated failure probabilities for a given
  set of quantiles and estimated parameters.
}
\description{
This function estimates the failure probabilities for a given set of
estimated location-scale parameters and specified quantiles.
}
\examples{
probs <- predict_prob(q = c(15, 48, 124), loc_sc_params = c(5, 0.5),
                           distribution = "weibull")
}
