% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_estimators.R
\name{mr_method}
\alias{mr_method}
\title{Estimation of Failure Probabilities using Median Ranks}
\usage{
mr_method(x, event = rep(1, length(x)), id = rep("XXXXXX", length(x)),
  method = "benard")
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{event}{a vector of ones indicating that every unit \emph{i} has failed.}

\item{id}{a character vector for the identification of every unit.}

\item{method}{method for the estimation of the cdf. Can be "benard" (default)
or "invbeta".}
}
\value{
A data frame containing id, lifetime characteristic, status of the
  unit, the rank and the estimated failure probability.
}
\description{
This non-parametric approach (\emph{Median Ranks}) is used to estimate the
failure probabilities in terms of complete data. Two methods are available to
estimate the cumulative distribution function \emph{F(t)}:
\itemize{
  \item "benard"; Benard's approximation for Median Ranks
  \item "invbeta"; Exact Median Ranks using the inverse beta distribution
}
}
\examples{
# Example 1
obs   <- seq(10000, 100000, 10000)
state <- rep(1, length(obs))
uic   <- c("3435", "1203", "958X", "XX71", "abcd", "tz46",
           "fl29", "AX23", "Uy12", "kl1a")

df_mr <- mr_method(x = obs, event = state, id = uic,
                   method = "benard")

# Example 2
df_mr_invbeta <- mr_method(x = obs, event = state, id = uic,
                           method = "invbeta")
}
