% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_multiscale_roughness}
\alias{wbt_multiscale_roughness}
\title{Multiscale roughness}
\usage{
wbt_multiscale_roughness(
  dem,
  out_mag,
  out_scale,
  max_scale,
  min_scale = 1,
  step = 1,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{out_mag}{Output raster roughness magnitude file.}

\item{out_scale}{Output raster roughness scale file.}

\item{max_scale}{Maximum search neighbourhood radius in grid cells.}

\item{min_scale}{Minimum search neighbourhood radius in grid cells.}

\item{step}{Step size as any positive non-zero integer.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates surface roughness over a range of spatial scales.
}
