% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning.R
\name{wbt_k_means_clustering}
\alias{wbt_k_means_clustering}
\title{K means clustering}
\usage{
wbt_k_means_clustering(
  inputs,
  output,
  classes,
  out_html = NULL,
  max_iterations = 10,
  class_change = 2,
  initialize = "diagonal",
  min_class_size = 10,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{inputs}{Input raster files.}

\item{output}{Output raster file.}

\item{classes}{Number of classes.}

\item{out_html}{Output HTML report file.}

\item{max_iterations}{Maximum number of iterations.}

\item{class_change}{Minimum percent of cells changed between iterations before completion.}

\item{initialize}{How to initialize cluster centres?.}

\item{min_class_size}{Minimum class size, in pixels.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a k-means clustering operation on a multi-spectral dataset.
}
