% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_tile}
\alias{wbt_lidar_tile}
\title{Lidar tile}
\usage{
wbt_lidar_tile(
  input,
  width = 1000,
  height = 1000,
  origin_x = 0,
  origin_y = 0,
  min_points = 2,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input LiDAR file.}

\item{width}{Width of tiles in the X dimension; default 1000.0.}

\item{height}{Height of tiles in the Y dimension.}

\item{origin_x}{Origin point X coordinate for tile grid.}

\item{origin_y}{Origin point Y coordinate for tile grid.}

\item{min_points}{Minimum number of points contained in a tile for it to be saved.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Tiles a LiDAR LAS file into multiple LAS files.
}
\keyword{LiDARTools}
