% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_analysis_classification.R
\name{wbt_generalize_classified_raster}
\alias{wbt_generalize_classified_raster}
\title{Generalize classified raster}
\usage{
wbt_generalize_classified_raster(
  input,
  output,
  min_size = 4,
  method = "longest",
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input raster image file.}

\item{output}{Name of the output raster file.}

\item{min_size}{Minimum feature size, in grid cells.}

\item{method}{Grouping method; one of 'longest' (default), 'largest', and 'nearest'.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Generalizes a raster containing class or object features by removing small features.
}
\keyword{ImageProcessingToolsClassification}
