% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_dist.R
\name{fig_dist}
\alias{fig_dist}
\title{Plot a distribution of a score}
\usage{
fig_dist(
  df,
  score,
  score_cat,
  cutoffs,
  x_lab = "Score",
  y_max = NULL,
  pcent = FALSE,
  pal = "Blues",
  binwidth = 5
)
}
\arguments{
\item{df}{a data frame where each row is an individual, containing at least a score column (between 0 and 100) and a categorization of that score}

\item{score}{a string (length 1) of the column name for the score variable to print the distribution of}

\item{score_cat}{a string (length 1) of the column name for the categorization of the score variable}

\item{cutoffs}{a numeric vector of the cut-offs for the score categorization}

\item{x_lab}{a string (length 1) of x-axis label. Default is "Score".}

\item{y_max}{a numeric value of the maximum limit on the y-axis. Default is NULL to use default value from \code{geom_histogram()}}

\item{pcent}{a logical value determining whether or not to display the distribution as percentages or frequency. Default is FALSE, to display as frequency.}

\item{pal}{a string to pass to \code{RColorBrewer::brewer.pal()} with the name of the color palette to use}

\item{binwidth}{a numeric value giving the width of the bins in the histograph. Default is 5.}
}
\value{
A score distribution figure with fill based on categorization of the score
}
\description{
Plot a distribution of a score
}
\details{
Plots a histogram of a score that ranges between 0 and 100, with the fill determined by some set categorization of the score. This is the function used to plot the distributions of disability scores resulting from the WHO Model Disability Survey.
}
\examples{
fig_dist(df_adults, score = "disability_score", score_cat = "disability_cat", 
cutoffs = c(19.1, 34.4, 49.6), x_lab = "Disability score")
fig_dist(df_adults, score = "disability_score", score_cat = "disability_cat", 
cutoffs = c(19.1, 34.4, 49.6), x_lab = "Disability score", y_max = 2000)
fig_dist(df_adults, score = "disability_score", score_cat = "disability_cat", 
cutoffs = c(19.1, 34.4, 49.6), x_lab = "Disability score", y_max = 0.2, pcent=TRUE)
}
\seealso{
Other figure functions: 
\code{\link{fig_LID}()},
\code{\link{fig_density}()},
\code{\link{fig_poppyramid}()}
}
\concept{figure functions}
