% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasch_mds.R
\name{rasch_mds}
\alias{rasch_mds}
\title{Top-level function to perform Rasch Analysis on WHO Model Disability Survey data}
\usage{
rasch_mds(
  df,
  vars_metric,
  vars_id,
  vars_DIF = NULL,
  resp_opts = 1:5,
  max_NA = 2,
  print_results = FALSE,
  path_parent = NULL,
  model_name = NULL,
  testlet_strategy = NULL,
  recode_strategy = NULL,
  drop_vars = NULL,
  split_strategy = NULL,
  comment = NULL
)
}
\arguments{
\item{df}{a data frame of individual survey data, where each row is an individual}

\item{vars_metric}{a character vector of items to use in the Rasch Analysis}

\item{vars_id}{a string with column name uniquely identifying individuals}

\item{vars_DIF}{a string with the column names to use for analyzing differential item functioning (DIF). Default is NULL, to skip analysis of DIF.}

\item{resp_opts}{a numeric vector of possible response options for \code{vars_metric}. Must begin with 1. Default is 1:5}

\item{max_NA}{a numeric value for the maximum number of NAs allowed per individual among \code{vars_metric}. Default is 2.}

\item{print_results}{a logical value indicating whether or not to print various files displaying results from the Rasch Model. Default is FALSE, to not print the files.}

\item{path_parent}{a string with the path to the folder where results from multiple models will be outputted. Default is NULL}

\item{model_name}{a string with a name for the model, which is used to create a new folder for model output. Default is NULL.}

\item{testlet_strategy}{a list giving the strategy to take for creating testlets, passed to \code{rasch_testlet()}. One element of the list per testlet to create. Each element of the list must be a character vector of column names to use for the testlet. Optionally, name the element of the list to give the name of the new testlet. Otherwise, the new testlet will be the original column names separated by "_". Default is NULL, to not create testlets.}

\item{recode_strategy}{a named list giving the strategy to take for recoding variables, passed to \code{rasch_recode()}. One element of the list per recode strategy. Each element of the list is a numeric vector giving the new values to map the variables to. The names of the list are the groups of column names to use for each recoding strategy, separated only by ",". Default is NULL, to not recode items.}

\item{drop_vars}{a character vector of column names to drop from the Rasch Analysis. Default is NULL, to not drop items.}

\item{split_strategy}{a named list giving the strategy to take for spliting variables by categories, passed to \code{rasch_split()}. One element of the list per variable to split by. Each element of the list must be a character vector of column names to split. The names of the list are the variables to split each group of variables by. Default is NULL, to not split items.}

\item{comment}{a string giving a comment describing the analysis, printed to a txt file. Default is NULL, to not print a comment.}
}
\value{
a named list with:
\item{df}{a tibble with new columns representing the original person abilities (\code{person_pars}) and the rescaled person abilities (\code{rescaled})} 
\item{vars_metric}{a character vector with the variables used in the metric after all adjustments}
\item{df_results}{a tibble of one row with key results of the model}

If \code{print_results} is TRUE, prints files to the working directory with the results of the Rasch Model.
}
\description{
Top-level function to perform Rasch Analysis on WHO Model Disability Survey data
}
\details{
This function combines all of the separate analyses of model fit necessary to assess the quality of the Rasch Model. It is designed to require minimal intervention from the user. Users wishing to have more control over the analysis can use the other Rasch functions in this package separately.
}
\seealso{
Other rasch functions: 
\code{\link{rasch_DIF}()},
\code{\link{rasch_df_nest}()},
\code{\link{rasch_drop}()},
\code{\link{rasch_factor}()},
\code{\link{rasch_mds_children}()},
\code{\link{rasch_model_children}()},
\code{\link{rasch_model}()},
\code{\link{rasch_quality_children_print}()},
\code{\link{rasch_quality_children}()},
\code{\link{rasch_rawscore}()},
\code{\link{rasch_recode}()},
\code{\link{rasch_rescale_children}()},
\code{\link{rasch_rescale}()},
\code{\link{rasch_split_age}()},
\code{\link{rasch_split}()},
\code{\link{rasch_testlet}()}
}
\concept{rasch functions}
