% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_Wikipedias}
\alias{w_Wikipedias}
\title{Gets Wikipedia pages from a Q list.}
\usage{
w_Wikipedias(entity_list, wikilangs = "", instanceof = "", nlimit = 1500)
}
\arguments{
\item{entity_list}{A vector of Wikidata entities.}

\item{wikilangs}{List of languages to limit the search, using "|" as
separator. Wikipedias page titles are returned in same order as languages in
this parameter. If wikilangs='' the function returns Wikipedia page titles
in any language, not sorted.}

\item{instanceof}{Wikidata entity class to limit the result to the instances
of that class. For example, if instanceof='Q5', limit the results to "human".}

\item{nlimit}{If the number of entities exceeds this number, chunked queries
are done. This is the number of entities requested in each chunk.}
}
\value{
A data-frame with four columns, first the count of Wikipedia pages,
second, the the langs, page title, and URL's of the wikipedia pages. Last
three use "|" as separator. Index of the data-frame is also set to the
entity_list.
}
\description{
Gets from Wikidata all Wikipedia page titles of the Wikidata entities in
entity_list. If set "instanceof", then only returns the pages for Wikidata
entities which are instances of that Wikidata class. If wikilangs='', then
returns all Wikipedia page titles, else only the languages in wikilangs.
Duplicated entities are deleted before search.
}
\examples{
# aux: get a vector of entities (l).
df <- w_SearchByLabel(string='Iranzo', langsorder='es|en', mode='inlabel')
l <- df$entity

w <- w_Wikipedias(entity_list=l)
w <- w_Wikipedias(entity_list=l, wikilangs='es|en|fr')
w <- w_Wikipedias(entity_list=l, wikilangs='es|en|fr', instanceof="Q5")
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
