% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkTO.R
\name{checkTO}
\alias{checkTO}
\title{Check for temporal overlap}
\usage{
checkTO(traj, traj2)
}
\arguments{
\item{traj}{an object of the class \code{move2} which contains the time-stamped movement fixes. For more information on objects of this type see \code{help(mt_as_move2)}.}

\item{traj2}{(optional) an object of the class \code{move2} which contains the time-stamped movement fixes. For more information on objects of this type see \code{help(mt_as_move2)}.}
}
\value{
A \code{data.frame} of with five columns, ID1, ID2, TO (logical indicating if the two tracking dataset overlap temporally), the beginning (\code{tmin}), and end (\code{tmax}) of the overlap period, stored as \code{POSIX} objects.
}
\description{
The function \code{checkTO} is a simple function for identifying if, and for how long, two telemetry datasets overlap (temporally) with each other. The function returns a dataframe with5 columns of information: the ids of the first an second individuals in a dyad, a logical variable indicating if the two trajectories overlap temporally, and timings of the beginning and end of the overlap period. If only a single move2 object is provided it considers all pairwise dyads within that move2 object. If two move2 objects are passed in it considers only the dyad pairs from traj against traj2. This can be used to test only the pairwise dyads between two groups (e.g., inter-species).
}
\details{
The function \code{checkTO} can be used to identify if, when, and for how long the tracking data of two individuals overlap temporally.
}
\examples{
data(does)
dyads <- checkTO(does)

}
\seealso{
GetSimultaneous, GetTO
}
\keyword{processing}
