% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitness.R
\name{fitness}
\alias{fitness}
\title{Evaluate the Individual Fitness values}
\usage{
fitness(
  selection,
  referenceHeight,
  RotorHeight,
  SurfaceRoughness,
  Polygon,
  resol1,
  rot,
  dirspeed,
  srtm_crop,
  topograp,
  cclRaster,
  weibull,
  Parallel,
  numCluster
)
}
\arguments{
\item{selection}{A list containing all individuals of the current population.}

\item{referenceHeight}{The height at which the incoming wind speeds were
measured. Default is \code{RotorHeight}}

\item{RotorHeight}{The height of the turbine hub}

\item{SurfaceRoughness}{A surface roughness length in meters. 
With the terrain effect model, a surface roughness is calculated for every 
grid cell using the elevation and land cover data. Default is \code{0.3}}

\item{Polygon}{The considered area as shapefile.}

\item{resol1}{The resolution of the grid in meter.}

\item{rot}{The desired rotor radius in meter.}

\item{dirspeed}{The wind data as list.}

\item{srtm_crop}{A list of 3 raster, with 1) the elevation, 2) an orographic
and 3) a terrain raster. Calculated in \code{\link{genetic_algorithm}}}

\item{topograp}{Boolean value, which indicates if the terrain effect model
should be enabled or not. Default is \code{FALSE}}

\item{cclRaster}{A Corine Land Cover raster, that has to be adapted
previously by hand with the surface roughness length for every land cover
type. Is only used, when the terrain effect model is activated.}

\item{weibull}{A raster representing the estimated wind speeds}

\item{Parallel}{A boolean value, indicating whether parallel processing should
be used. The *parallel* and *doParallel* packages are used for parallel
processing. Default is \code{FALSE}}

\item{numCluster}{If \code{Parallel} is TRUE, this variable defines the 
number of clusters to be used. Default is \code{2}}
}
\value{
Returns a list with every individual, consisting of X & Y
  coordinates, rotor radii, the runs and the selected grid cell IDs, and the
  resulting energy outputs, efficiency rates and fitness values.
}
\description{
The fitness of all individuals in the current population
  is calculated after their energy output has been evaluated in
  \code{\link{calculate_energy}}. This function reduces the resulting energy
  outputs to a single fitness value for each individual.
}
\examples{
\donttest{
## Create a random rectangular shapefile
library(sf)
Polygon1 <- sf::st_as_sf(sf::st_sfc(
  sf::st_polygon(list(cbind(
    c(4498482, 4498482, 4499991, 4499991, 4498482),
    c(2668272, 2669343, 2669343, 2668272, 2668272)))), 
  crs = 3035
))

## Create a uniform and unidirectional wind data.frame and plots the
## resulting wind rose
## Uniform wind speed and single wind direction
wind <- data.frame(ws = 12, wd = 0)
# windrosePlot <- plot_windrose(data = wind, spd = wind$ws,
#                dir = wind$wd, dirres=10, spdmax=20)

## Calculate a Grid and an indexed data.frame with coordinates and
## grid cell IDs.
Grid1 <- grid_area(shape = Polygon1, size = 200, prop = 1);
Grid <- Grid1[[1]]
AmountGrids <- nrow(Grid)

wind <- list(wind, probab = 100)
startsel <- init_population(Grid,10,20);
fit <- fitness(selection = startsel, referenceHeight = 100, RotorHeight=100,
               SurfaceRoughness=0.3,Polygon = Polygon1, resol1 = 200,rot=20,
               dirspeed = wind, srtm_crop="", topograp=FALSE, cclRaster="",
               Parallel = FALSE)
}
}
\seealso{
Other Genetic Algorithm Functions: 
\code{\link{crossover}()},
\code{\link{genetic_algorithm}()},
\code{\link{init_population}()},
\code{\link{mutation}()},
\code{\link{selection}()},
\code{\link{trimton}()},
\code{\link{windfarmGA}()}
}
\concept{Genetic Algorithm Functions}
