% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_duplicated.R
\name{row_duplicated}
\alias{row_duplicated}
\alias{row_duplicated.matrix}
\alias{row_duplicated.data.frame}
\title{Conditions related to duplicated values}
\usage{
row_duplicated(.data, match_type = NULL, output_class, ...)

\method{row_duplicated}{matrix}(.data, match_type = NULL, output_class, ...)

\method{row_duplicated}{data.frame}(.data, match_type = NULL, output_class, ...)
}
\arguments{
\item{.data}{A two-dimensional data structure.}

\item{match_type}{One of (\code{NULL}, "any", "none", "which_first", "count"). Possibly abbreviated.}

\item{output_class}{Passed to \code{\link[=op_ctrl]{op_ctrl()}}. If missing, it will be inferred.}

\item{...}{
  Arguments passed on to \code{\link[=op_ctrl]{op_ctrl}}
  \describe{
    \item{\code{cols}}{A vector indicating which columns to consider for the operation. If \code{NULL}, all
columns are used. If its length is 0, no columns are considered. Negative numbers, logical
values, character vectors representing column names, and \link[tidyselect:select_helpers]{tidyselect::select_helpers} are
supported.}
    \item{\code{rows}}{Like \code{cols} but for row indices, and without \code{tidyselect} support.}
    \item{\code{factor_mode}}{One of ("character", "integer"), possibly abbreviated. If a column is a
factor, this determines whether the operation uses its internal integer values, or the
character values from its levels.}
  }}
}
\description{
Conditions related to duplicated values
}
\details{
For each row, different checks can be performed on whether there are duplicated values among the
columns. The default (when \code{match_type = NULL}) returns a logical matrix/data.frame with the same
number of columns as the input, where each column indicates whether the corresponding input
column is duplicated for that row. Other \code{match_type} values perform aggregations and are
self-explanatory.

Care must be taken for input data frames whose columns have different types. Type promotion will
follow normal R rules:

logical -> integer -> double -> complex -> character

For each row, the set of seen values starts as logical. If the value in a new column requires
promotion, all values in the set are promoted accordingly. This continues iteratively for each
column in the row. See the examples.
}
\examples{

# after processing the 2nd column, all values will be promoted to character
row_duplicated(data.frame(TRUE, "TRUE", TRUE))

# after the 1st column the set of seen values is (TRUE)
# after the 2nd column, TRUE is promoted to 1, and the set is (1)
# after the 3rd column, 1 is promoted to "1", and the set is ("1", "FALSE")
# the final column is thus promoted to "TRUE"
row_duplicated(data.frame(TRUE, 1L, "FALSE", TRUE))

}
