% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iwish_psn.R
\name{iwish_psn}
\alias{iwish_psn}
\title{Inverse of a Coefficient Matrix \eqn{\tilde{\mathcal{H}}_k}}
\usage{
iwish_psn(k, n1, alpha = 2)
}
\arguments{
\item{k}{The order of the \eqn{\tilde{\mathcal{H}}_k} matrix (a positive integer)}

\item{n1}{The parameter \eqn{n-m+1-\alpha}, where:
\itemize{
\item \eqn{n} is the degrees of freedom of \eqn{W}
\item \eqn{m} is the number of rows of \eqn{W}
}}

\item{alpha}{The type of Wishart distribution (\eqn{\alpha = 2/\beta}):
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}
}
\value{
Inverse of a coefficient matrix \eqn{\tilde{\mathcal{H}}_k} that allows us
to compute the expected value of a power-sum symmetric function of \eqn{W^{-1}},
where \eqn{W \sim W_m^{\beta}(n,\Sigma)}.
}
\description{
This function computes the inverse of a coefficient matrix \eqn{\tilde{\mathcal{H}}_k}
that allows us to compute the expected value of a power-sum symmetric
function of \eqn{W^{-1}}, where \eqn{W \sim W_m^{\beta}(n,\Sigma)}.
}
\examples{
# Example 1:
iwish_psn(3, 10) # For real Wishart distribution with k = 3 and n1 = 10

# Example 2:
iwish_psn(4, 10, 1) # For complex Wishart distribution with k = 4 and n1 = 10

# Example 3:
iwish_psn(2, 10, 1/2) # For quaternion Wishart distribution with k = 2 and n1 = 10
}
