% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qk_coeffn.R
\name{qk_coeffn}
\alias{qk_coeffn}
\title{Coefficient Matrix \eqn{\mathcal{C}_k}}
\usage{
qk_coeffn(k, n, alpha = 2)
}
\arguments{
\item{k}{The order of the \eqn{\mathcal{C}_k} matrix}

\item{n}{The degrees of freedom of the beta-Wishart matrix \eqn{W}}

\item{alpha}{The type of Wishart distribution (\eqn{\alpha=2/\beta}):
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}
}
\value{
\eqn{\mathcal{C}_k}, a matrix that allows us to obtain
\eqn{E[p_{\lambda}(W)W^r]}, where \eqn{r+|\lambda|=k} and \eqn{W \sim W_m^{\beta}(n, \Sigma)}.
}
\description{
This function computes the coefficient matrix \eqn{\mathcal{C}_k}, which
is a matrix of constants that allows us to obtain \eqn{E[p_{\lambda}(W)W^r]},
where \eqn{r+|\lambda|=k} and \eqn{W \sim W_m^{\beta}(n, \Sigma)}.
}
\examples{
# Example 1:
qk_coeffn(2, 2) # For real Wishart distribution with k = 2 and n = 2

# Example 2:
qk_coeffn(3, 2, 1) # For complex Wishart distribution with k = 3 and n = 2

# Example 3:
qk_coeffn(2, 2, 1/2) # For quaternion Wishart distribution with k = 2 and n = 2
}
