% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wood-dependencies.R
\name{wood_dependencies}
\alias{wood_dependencies}
\title{Find dependencies from multiple repositories}
\usage{
wood_dependencies(packages, repos = "cran")
}
\arguments{
\item{packages}{\code{character()}\cr
Names of the packages to query for.}

\item{repos}{\code{character()}\cr
A vector of repositories to query. The following values are available:
\itemize{
\item \code{"cran"}, meaning CRAN;
\item \code{"bioc@release"}, meaning Bioconductor, where \code{release} should be replaced
with a valid Bioconductor release code or one of \code{"release"}, \code{"devel"};
\item \code{"github/user"}, meaning GitHub, where \code{user} should be replaced with a
valid user or organization name (e.g. \code{turtletopia});
\item \code{"runiverse@universe"}, meaning R-universe, where \code{universe} should be
replaced with a valid universe name (e.g. \code{turtletopia});
\item \code{"local#index"}, meaning a local library, where \code{index} should be replaced
with an integer index of a library in \code{\link[base:libPaths]{base::.libPaths()}} or an \code{all}
keyword;
\item \code{"core"}, meaning base R packages;
\item a URL if none of the above is matched.
}}
}
\value{
A list named after queried packages, each element being a data frame
with three columns, all in string format:
\itemize{
\item \code{package} (package name),
\item \code{version} (minimum version requirement or \code{NA} if none),
\item \code{type} (dependency type, e.g. \code{"Imports"}).
}
}
\description{
This function queries the selected repositories for dependencies
of the selected packages and returns the first working occurence.
}
\examples{
\donttest{
wood_dependencies("stats", "core")
# Multiple packages are also possible:
wood_dependencies(
  c("tibble", "Biostrings", "woodendesc"),
  repos = c("runiverse@turtletopia", "cran", "bioc@1.5")
)
# By default, only CRAN is queried:
wood_dependencies("versionsort")
}

}
\seealso{
Functions for all repositories:
\code{\link{wood_packages}()},
\code{\link{wood_versions}()}

Functions that query package dependencies:
\code{\link{wood_bioc_dependencies}()},
\code{\link{wood_core_dependencies}()},
\code{\link{wood_cran_dependencies}()},
\code{\link{wood_github_dependencies}()},
\code{\link{wood_local_dependencies}()},
\code{\link{wood_runiverse_dependencies}()},
\code{\link{wood_url_dependencies}()}
}
\concept{dependencies}
\concept{wood}
