% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{git_user}
\alias{git_user}
\title{Set global 'Git' credentials}
\usage{
git_user(name, email, overwrite = !has_git_user())
}
\arguments{
\item{name}{Character. The user name you want to use with 'Git'.}

\item{email}{Character. The email address you want to use with 'Git'.}

\item{overwrite}{Logical. Whether or not to overwrite existing 'Git'
credentials. Use this to prevent code from accidentally overwriting existing
'Git' credentials. The default value uses \code{\link{has_git_user}}
to set overwrite to \code{FALSE} if user credentials already exist, and to
\code{TRUE} if no user credentials exist.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
This function is a wrapper for
\code{\link[gert]{git_config_global_set}}. It sets two name/value pairs at
once: \code{name = "user.name"} is set to the value of the \code{name}
argument, and \code{name = "user.email"} is set to the value of the
\code{email} argument.
}
\examples{
do.call(git_user, worcs:::get_user())
}
