% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-wp-posts.R
\name{get_wp_posts}
\alias{get_wp_posts}
\title{Retrieve WordPress Posts}
\usage{
get_wp_posts(root_url, post_count = Inf, after_date = NULL)
}
\arguments{
\item{root_url}{The WordPress site for which posts are sought to be retrieved.}

\item{post_count}{The maximum number of posts to return, sorted by the most recent date. Default value is to return all posts made on the site.}

\item{after_date}{The date after which posts should be returned.}
}
\value{
A data frame returning the post ID, publication date, title, excerpt, content, tag IDs, category IDs, and author IDs.
}
\description{
Retrieve posts made on the WordPress site.
}
\examples{
\dontrun{
get_wp_posts(root_url = 'https://domain.com',post_count = 200, after_date = NULL)
}

}
