% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_status.R
\name{wflow_status}
\alias{wflow_status}
\title{Report status of workflowr project}
\usage{
wflow_status(files = NULL, project = ".")
}
\arguments{
\item{files}{character (default: NULL) The analysis file(s) to report the
status. By default checks the status of all analysis files. Supports
file \href{https://en.wikipedia.org/wiki/Glob_(programming)}{globbing}.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
Returns an object of class \code{wflow_status}, which is a list with
  the following elements:

\itemize{

\item \bold{root}: The relative path to the root directory of the workflowr
project (i.e. contains the RStudio .Rproj file).

\item \bold{analysis}: The relative path to the directory that contains
\code{_site.yml} and the R Markdown files.

\item \bold{docs}: The relative path to the directory that contains the HTML
files and figures.

\item \bold{git}: The relative path to the \code{.git} directory that
contains the history of the Git repository.

\item \bold{status}: A data frame with detailed information on the status of
each file (see below).

}

The data frame \code{status} contains the following non-mutually exclusive
columns (all logical vectors):

\itemize{

\item \bold{ignored}: The R Markdown file has been ignored by Git according
to the patterns in the file \code{.gitignore}.

\item \bold{mod_unstaged}: The R Markdown file has unstaged modifications.

\item \bold{conflicted}: The R Markdown file has merge conflicts.

\item \bold{mod_staged}: The R Markdown file has staged modifications.

\item \bold{tracked}: The R Markdown file is tracked by Git.

\item \bold{committed}: The R Markdown file has been previously committed to
the Git repository.

\item \bold{published}: The corresponding HTML file has been previously
committed.

\item \bold{mod_committed}: The R Markdown file has modifications that have
been committed since the last time the HTML was built and committed.

\item \bold{modified}: The R Markdown file has been modified since it was
last published (i.e. \code{mod_unstaged} or \code{mod_staged} or
\code{mod_committed}).

\item \bold{unpublished}: The R Markdown file is tracked by Git but not
published (i.e. the HTML has not been committed).

\item \bold{scratch}: The R Markdown file is untracked by Git, i.e. it is
considered a scratch file until it is committed.

}
}
\description{
\code{wflow_status} reports the analysis files that require user action.
}
\details{
\code{wflow_status} reports analysis files with one of the following
statuses:

\itemize{

\item \bold{Mod}: Modified file. Any published file that has been modified
since the last time the HTML was published.

\item \bold{Unp}: Unpublished file. Any tracked file whose corresponding HTML
is not tracked. May or may not have staged or unstaged changes.

\item \bold{Scr}: Scratch file. Any untracked file that is not specifically
ignored.

}

\code{wflow_status} only works for workflowr projects that use Git.
}
\examples{
\dontrun{

wflow_status()
# Get status of specific file(s)
wflow_status("analysis/file.Rmd")
# Save the results
s <- wflow_status()
}
}
