% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_rename_proj.R
\name{wflow_rename_proj}
\alias{wflow_rename_proj}
\title{Rename a workflowr project}
\usage{
wflow_rename_proj(
  name,
  rproj = TRUE,
  remote = TRUE,
  navbar = TRUE,
  readme = TRUE,
  commit = TRUE,
  directory = TRUE,
  project = "."
)
}
\arguments{
\item{name}{character. The new name for the workflowr project.}

\item{rproj}{logical (default: TRUE). Rename the RStudio Project file.}

\item{remote}{logical (default: TRUE). Rename the remote URL.}

\item{navbar}{logical (default: TRUE). Rename the navbar title.}

\item{readme}{logical (default: TRUE). Rename the README title.}

\item{commit}{logical (default: TRUE). Commit the changes to Git.}

\item{directory}{logical (default: TRUE). Rename the project directory.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
Invisibly returns the path to the project directory
}
\description{
If you want to rename an existing workflowr project, use
\code{wflow_rename_proj} to update the name throughout all the project files.
}
\details{
\code{wflow_rename_proj} performs the following steps and then commits the
changes:

\itemize{

\item Rename RStudio Project file (\code{.Rproj})

\item Update URL of remote repository (see \code{\link{wflow_git_remote}})

\item Update project name in the navigation bar (defined in \code{_site.yml})

\item Update title of README file

\item Rename the project directory itself

}

After renaming the project with \code{wflow_rename_proj}, you should
republish the R Markdown files with \code{wflow_publish(republish = TRUE)}.
Also, you should go to the settings of your Git repository on the online Git
hosting platform to change its name.
}
\examples{
\dontrun{

wflow_rename_proj("new-project-name")
}

}
\seealso{
\code{\link{wflow_publish}}
}
