% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre-action-case-weights.R
\name{add_case_weights}
\alias{add_case_weights}
\alias{remove_case_weights}
\alias{update_case_weights}
\title{Add case weights to a workflow}
\usage{
add_case_weights(x, col)

remove_case_weights(x)

update_case_weights(x, col)
}
\arguments{
\item{x}{A workflow}

\item{col}{A single unquoted column name specifying the case weights for
the model. This must be a classed case weights column, as determined by
\code{\link[hardhat:is_case_weights]{hardhat::is_case_weights()}}.}
}
\description{
This family of functions revolves around selecting a column of \code{data} to use
for \emph{case weights}. This column must be one of the allowed case weight types,
such as \code{\link[hardhat:frequency_weights]{hardhat::frequency_weights()}} or \code{\link[hardhat:importance_weights]{hardhat::importance_weights()}}.
Specifically, it must return \code{TRUE} from \code{\link[hardhat:is_case_weights]{hardhat::is_case_weights()}}. The
underlying model will decide whether or not the type of case weights you have
supplied are applicable or not.
\itemize{
\item \code{add_case_weights()} specifies the column that will be interpreted as
case weights in the model. This column must be present in the \code{data}
supplied to \link[=fit.workflow]{fit()}.
\item \code{remove_case_weights()} removes the case weights. Additionally, if the
model has already been fit, then the fit is removed.
\item \code{update_case_weights()} first removes the case weights, then replaces them
with the new ones.
}
}
\details{
For formula and variable preprocessors, the case weights \code{col} is removed
from the data before the preprocessor is evaluated. This allows you to use
formulas like \code{y ~ .} or tidyselection like \code{everything()} without fear of
accidentally selecting the case weights column.

For recipe preprocessors, the case weights \code{col} is not removed and is
passed along to the recipe. Typically, your recipe will include steps that
can utilize case weights.
}
\examples{
library(parsnip)
library(magrittr)
library(hardhat)

mtcars2 <- mtcars
mtcars2$gear <- frequency_weights(mtcars2$gear)

spec <- linear_reg() \%>\%
  set_engine("lm")

wf <- workflow() \%>\%
  add_case_weights(gear) \%>\%
  add_formula(mpg ~ .) \%>\%
  add_model(spec)

wf <- fit(wf, mtcars2)

# Notice that the case weights (gear) aren't included in the predictors
extract_mold(wf)$predictors

# Strip them out of the workflow, which also resets the model
remove_case_weights(wf)
}
