% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportADMS.R
\name{exportADMS}
\alias{exportADMS}
\title{Export a meteorological data frame in ADMS format}
\usage{
exportADMS(dat, out = "./ADMS_met.MET", interp = FALSE, maxgap = 2)
}
\arguments{
\item{dat}{A data frame imported by \code{\link{importNOAA}}.}

\item{out}{A file name for the ADMS file. The file is written to the working 
directory by default.}

\item{interp}{Should interpolation of missing values be undertaken? If 
\code{TRUE} linear interpolation is carried out for gaps of up to and 
including \code{maxgap}.}

\item{maxgap}{The maximum gap in hours that should be interpolated where 
there are missing data when \code{interp = TRUE.} Data with gaps more than
\code{maxgap} are left as missing.}
}
\value{
Writes a text file to a location of the user's choosing.
}
\description{
Export a meteorological data frame in ADMS format
}
\examples{

\dontrun{
## import some data then export it
dat <- importNOAA(year = 2012)
exportADMS(dat, file = "~/temp/adms_met.MET")
}
}

