% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personas_hclust.R
\name{personas_hclust}
\alias{personas_hclust}
\title{Create hierarchical clusters of selected metrics using a Person query}
\usage{
personas_hclust(data, metrics, k = 4, return = "plot")
}
\arguments{
\item{data}{A data frame containing \code{PersonId} and selected metrics for
clustering.}

\item{metrics}{Character vector containing names of metrics to use for
clustering. See examples section.}

\item{k}{Numeric vector to specify the \code{k} number of clusters to cut by.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"data"}
\item \code{"table"}
\item \code{"hclust"}
}

See \code{Value} for more information.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: 'ggplot' object. A heatmap plot comparing the key metric averages
of the clusters as per \code{keymetrics_scan()}.
\item \code{"data"}: data frame. Raw data with clusters appended
\item \code{"table"}: data frame. Summary table for identified clusters
\item \code{"hclust"}: 'hclust' object. hierarchical model generated by the function.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}

Apply hierarchical clustering to selected metrics. Person averages are computed prior to clustering.
The hierarchical clustering uses cosine distance and the ward.D method
of agglomeration.
}
\examples{
# Return plot
personas_hclust(sq_data,
                metrics = c("Collaboration_hours", "Workweek_span"),
                k = 4)

# Return summary table
personas_hclust(sq_data,
                metrics = c("Collaboration_hours", "Workweek_span"),
                k = 4,
                return = "table")

\donttest{
# Return data with clusters appended
personas_hclust(sq_data,
                metrics = c("Collaboration_hours", "Workweek_span"),
                k = 4,
                return = "data")
}


}
\seealso{
Other Clustering: 
\code{\link{workpatterns_classify}()},
\code{\link{workpatterns_hclust}()}
}
\author{
Ainize Cidoncha \href{mailto:ainize.cidoncha@microsoft.com}{ainize.cidoncha@microsoft.com}
}
\concept{Clustering}
