% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonAmbiguousNum.R
\name{nonAmbiguousNum}
\alias{nonAmbiguousNum}
\title{make numeric vector non-ambiguous (ie unique)}
\usage{
nonAmbiguousNum(x, uniqOnly = FALSE, asList = FALSE,
  nameMod = "amb_", callFrom = NULL)
}
\arguments{
\item{x}{(numeric) main input}

\item{uniqOnly}{(logical) if=TRUE return unique only, if =FALSE return unique and single representative of non-unique values (with '' added to name), selection of representative of repeated: first (of sorted) or middle if >2 instances}

\item{asList}{(logical) return list}

\item{nameMod}{(character) text to add in case on ambiguous values, default="amb_"}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
sorted non-ambigous numeric vector (or list if 'asList'=TRUE and 'uniqOnly'=FALSE)
}
\description{
\code{nonAmbiguousNum} makes (named) values of numeric vector 'x' unique. 
Note: for non-numeric use  \code{\link{firstOfRepeated}} - but 1000x slower !
Return sorted non-ambigous numeric vector (or list if 'asList'=TRUE and 'uniqOnly'=FASLSE)
}
\examples{
set.seed(2017); aa <- round(rnorm(100),2); names(aa) <- 1:length(aa)
str(nonAmbiguousNum(aa))
str(nonAmbiguousNum(aa,uniq=FALSE,asLi=TRUE))
}
\seealso{
\code{\link{firstOfRepeated}} for non-numeric use (much slower !!!), \code{\link[base]{duplicated}}
}
