% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replNAbyLow.R
\name{replNAbyLow}
\alias{replNAbyLow}
\title{Replace NAs by low values}
\usage{
replNAbyLow(x, grp, quant = 0.8, signific = 3, unif = TRUE,
  absOnly = FALSE, seed = NULL, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{x}{(numeric matrix or data.frame) main input}

\item{grp}{(factor) to organize replicate columns of (x)}

\item{quant}{(numeric) quantile form 'neighbour' values to use as upper limit for random values}

\item{signific}{number of signif digits for random values}

\item{unif}{(logical) toggle between uniform and Gaussian random values}

\item{absOnly}{(logical) if TRUE, make negative NA-replacment values positive as absolute values}

\item{seed}{(integer) for use with set.seed for reproducible output}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
numeric matrix (same dim as 'x') with \code{NA} replaced
}
\description{
With several screening techniques used in hight-throughput biology values at/below detection limit are returned as \code{NA}.
However, the resultant \code{NA}-values may be difficult to analyse properly, simply ignoring \code{NA}-values mat not be a good choice.
When (technical) replicate measurements are available, one can look for cases where one gave an \code{NA} while the other did not 
with the aim of investigating such 'NA-neighbours'.  
\code{replNAbyLow} locates and replaces \code{NA} values by (random) values from same line & same group 'grp'. 
The origin of NAs should be predominantly absence of measure (quantitation) due to signal below limit of detection
and not saturation at upper detection limit or other technical problems.  
Note, this approach may be not optimal if the number of NA-neighbours is very low.
Replacamet is done -depending on agrument 'unif'- by Gaussian random model based on neighbour values (within same group),
using their means and sd, or a uniform random model (min and max of neighbour values) .
Then numeric matrix (same dim as 'x') with \code{NA} replaced is returned.
}
\examples{
dat <- matrix(round(rnorm(30),2),ncol=6); grD <- gl(2,3)
dat[sort(sample(1:30,9,repl=FALSE))] <- NA
dat; replNAbyLow(dat,gr=grD)
}
\seealso{
\code{\link{naOmit}}, \code{\link[stats]{na.fail}}
}
