% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeAlizer.R
\name{writeAlizer}
\alias{writeAlizer}
\title{writeAlizer: An R Package to Generate Automated Writing Quality and Curriculum-Based Measurement (CBM) Scores.}
\description{
Detailed documentation on writeAlizer is available in the \href{https://github.com/shmercer/writeAlizer}{GitHub README file}
and \href{https://github.com/shmercer/writeAlizer/wiki}{wiki}
}
\details{
The writeAlizer R package (a) imports \href{https://github.com/readerbench/readerbench-java}{ReaderBench},
\href{https://soletlab.asu.edu/coh-metrix/}{Coh-Metrix}, and \href{https://www.linguisticanalysistools.org/gamet.html}{GAMET} output files into R,
and (b) uses research-developed scoring models to generate predicted writing
quality scores or Correct Word Sequences and Correct Minus Incorrect Word Sequences
scores from the ReaderBench, Coh-Metrix, and/or GAMET files.

The writeAlizer package includes functions to do two types of tasks:
(1) importing ReaderBench, Coh-Metrix, and/or GAMET output files into R;
and (2) generating predicted quality scores using the imported output files.
}
\section{1. Import output files}{

\code{\link{import_rb}}

\code{\link{import_coh}}

\code{\link{import_gamet}}

\code{\link{import_merge_gamet_rb}}
}

\section{2. Generate predicted quality scores}{

\code{\link{predict_quality}}
}

