% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/race.pred.R
\name{race.pred}
\alias{race.pred}
\title{Race prediction function.}
\usage{
race.pred(voters, races = c("white", "black", "latino", "asian", "other"),
  name.clean = TRUE, surname.only = FALSE, census = "", census.key = "",
  demo = FALSE, party, census.data = NA)
}
\arguments{
\item{voters}{An object of class \code{data.frame}. Must contain a row for each individual being 
predicted, as well as a field named \code{\var{surname}} containing each individual's surname.
If using geolocation in predictions, \code{\var{voters}} must contain a field named \code{\var{state}}, 
which contains the two-character abbreviation for each individual's state of residence (e.g., "nj" for New Jersey). 
If using geolocation, \code{\var{voters}} must also contain at least one of the following fields: 
\code{\var{county}}, \code{\var{tract}}, and/or \code{\var{block}}. 
These fields should contain character strings matching U.S. Census categories. 
County is three characters (e.g., "031" not "31"), tract is six characters, and block is four characters. 
See below for other optional fields.}

\item{races}{A character vector specifying which racial groups to generate 
predicted probabilities for. Can include any subset of the default vector, 
which is \code{c("white", "black", "latino", "asian", "other")}.}

\item{name.clean}{A \code{TRUE}/\code{FALSE} object. If \code{TRUE}, function will call
\code{name.clean} to merge in data from U.S. Census 2000 Surname List 
and Spanish Surname List. If \code{FALSE}, voters object must contain additional fields 
specifying Pr(Race | Surname), named as follows: 
\code{\var{p_whi}} for Whites, \code{\var{p_bla}} for Blacks, 
\code{\var{p_his}} for Hispanics/Latinos, \code{\var{p_asi}} for Asians, 
and/or \code{\var{p_oth}} for Other. Default is \code{TRUE}.}

\item{surname.only}{A \code{TRUE}/\code{FALSE} object. If \code{TRUE}, race predictions will 
only use surname data and calculate Pr(Race | Surnname). Default is \code{FALSE}.}

\item{census}{An optional character vector specifying what level of 
geography to use to merge in U.S. Census 2010 data. Can be one of 
\code{"county"}, \code{"tract"}, or \code{"block"}. 
Function calls \code{census.helper.api} to merge in Census data at specified level. 
If left unspecified, \code{voters} must contain additional fields 
specifying Pr(Geolocation | Race), including any of the following: 
\code{\var{r_whi}}, \code{\var{r_bla}}, \code{\var{r_his}}, 
\code{\var{r_asi}}, and/or \code{\var{r_oth}}.}

\item{census.key}{A character object specifying user's Census API 
key. Required if \code{census} is specified, because 
\code{census.helper} function requires a Census API key to operate.}

\item{demo}{An optional \code{TRUE}/\code{FALSE} object specifying whether to 
condition race predictions on individual age and sex (in addition to geolocation). 
Default is \code{FALSE}. 
May only be set to \code{TRUE} if \code{census} option is specified. 
If \code{TRUE}, \code{voters} should include numerical variables 
\code{\var{age}} and \code{\var{sex}}, where \code{\var{sex}} coded as 0 for 
males and 1 for females.}

\item{party}{An optional character object specifying party registration field in \code{\var{voters}}, 
e.g., \code{\var{party} = "PartyReg"}. If specified, race/ethnicity predictions will be conditioned 
on individual's party registration (in addition to geolocation). 
Whatever the name of the party registration field in \code{\var{voters}}, 
it should be coded as 1 for Democrat, 2 for Republican, and 0 for Other.}

\item{census.data}{A census data object, a list indexed by state names, 
which contains census data on demo, county, tract and block.}
}
\value{
Output will be an object of class \code{data.frame}. It will 
 consist of the original user-input data with additional columns that 
 contain predicted probabilities for each race in \code{races}.
}
\description{
\code{race.pred} makes probabilistic estimates of individual-level race/ethnicity.
}
\details{
This function implements the Bayesian race prediction methods outlined in 
Imai and Khanna (2015). The function produces probabilistic estimates of 
individual-level race/ethnicity, based on surname, geolocation, and party.
}
\examples{
data(voters)
race.pred(voters = voters, races = c("asian"), surname.only = TRUE)
\dontrun{race.pred(voters = voters, races = c("white", "black", "latino"), 
census = "tract", census.key = "...", demo = TRUE)}
\dontrun{race.pred(voters = voters, races = c("white", "black", "latino", "asian", "other"), 
census = "tract", census.key = "...", party = "PID")}
\dontrun{race.pred(voters = voters, races = c("white", "black", "latino", "asian", "other"), 
census = "tract", census.data = censusObjs, party = "PID")}
}

