% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{power}
\alias{power}
\alias{power.tts}
\title{Power of a \code{tts} object}
\usage{
power(object)

\method{power}{tts}(object)
}
\arguments{
\item{object}{A \code{tts} object}
}
\value{
\code{power} returns a data frame with columns timescales and power
}
\description{
Returns the power of a \code{tts} object, i.e., the mean over
time of the squared magnitude (which is a function of timescale)
}
\examples{
times<-1:10
timescales<-1:10
values<-matrix(rep(complex(modulus=1,argument=2*pi*c(0:9)/10),times=10),10,10)
ttsobj<-tts(times,timescales,values)
res<-power(ttsobj)
 
}
\seealso{
\code{\link{tts}}, \code{\link{wt}}, \code{\link{wmf}}, \code{\link{wpmf}},
\code{browseVignettes("wsyn")}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
