% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_methods.R
\name{coh_methods}
\alias{coh_methods}
\alias{summary.coh}
\alias{print.coh}
\alias{set_times.coh}
\alias{set_timescales.coh}
\alias{set_coher.coh}
\alias{set_dat1.coh}
\alias{set_dat2.coh}
\alias{set_wtopt.coh}
\alias{set_norm.coh}
\alias{set_sigmethod.coh}
\alias{set_signif.coh}
\alias{set_ranks.coh}
\alias{set_bandp.coh}
\alias{get_times.coh}
\alias{get_timescales.coh}
\alias{get_coher.coh}
\alias{get_dat1.coh}
\alias{get_dat2.coh}
\alias{get_wtopt.coh}
\alias{get_norm.coh}
\alias{get_sigmethod.coh}
\alias{get_signif.coh}
\alias{get_ranks.coh}
\alias{get_bandp.coh}
\title{Basic methods for the \code{coh} class}
\usage{
\method{summary}{coh}(object, ...)

\method{print}{coh}(x, ...)

\method{set_times}{coh}(obj, newval)

\method{set_timescales}{coh}(obj, newval)

\method{set_coher}{coh}(obj, newval)

\method{set_dat1}{coh}(obj, newval)

\method{set_dat2}{coh}(obj, newval)

\method{set_wtopt}{coh}(obj, newval)

\method{set_norm}{coh}(obj, newval)

\method{set_sigmethod}{coh}(obj, newval)

\method{set_signif}{coh}(obj, newval)

\method{set_ranks}{coh}(obj, newval)

\method{set_bandp}{coh}(obj, newval)

\method{get_times}{coh}(obj)

\method{get_timescales}{coh}(obj)

\method{get_coher}{coh}(obj)

\method{get_dat1}{coh}(obj)

\method{get_dat2}{coh}(obj)

\method{get_wtopt}{coh}(obj)

\method{get_norm}{coh}(obj)

\method{get_sigmethod}{coh}(obj)

\method{get_signif}{coh}(obj)

\method{get_ranks}{coh}(obj)

\method{get_bandp}{coh}(obj)
}
\arguments{
\item{object, x, obj}{An object of class \code{coh}}

\item{...}{Not currently used. Included for argument consistency
with existing generics.}

\item{newval}{A new value, for the \code{set_*} methods}
}
\value{
\code{summary.coh} produces a summary of a \code{coh} object.
A \code{print.coh} method is also available. For \code{coh} objects, 
\code{set_*} and \code{get_*} methods are available for all slots (see
the documentation for \code{coh} for a list). The \code{set_*} methods 
just throw an error, to prevent breaking the consistency between the 
slots of a \code{coh} object.
}
\description{
Set, get, summary, and print methods for the \code{coh} class.
}
\examples{
times<-1:100
dat1<-matrix(rnorm(1000),10,100)
dat2<-matrix(rnorm(1000),10,100)
dat1<-cleandat(dat1,times,1)$cdat
dat2<-cleandat(dat2,times,1)$cdat
norm<-"powall"
sigmethod<-"fast"
nrand<-10
h<-coh(dat1,dat2,times,norm,sigmethod,nrand)
get_times(h)
summary(h)
print(h)

}
\seealso{
\code{\link{coh}}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
