% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotrank.R
\name{plotrank}
\alias{plotrank}
\alias{plotrank.coh}
\alias{plotrank.wlmtest}
\alias{plotrank.default}
\title{Plots \code{ranks} slot for \code{coh} and \code{wlmtest} objects}
\usage{
plotrank(object, ...)

\method{plotrank}{coh}(object, sigthresh = 0.95, bandprows = "all",
  filename = NA, ...)

\method{plotrank}{wlmtest}(object, sigthresh = 0.95, bandprows = "all",
  filename = NA, ...)

\method{plotrank}{default}(object, ...)
}
\arguments{
\item{object}{A \code{coh} or \code{wlmtest} object. Must have a non-\code{NA} \code{signif} slot.}

\item{...}{Passed from the generic to specific methods. Not currently used.}

\item{sigthresh}{Significance threshold(s). Numeric vector with values between 0 and 1. Typically 
0.95, 0.99, 0.999, etc. The threshhold(s) are plotted on the rank plot as dashed horizontal line(s).}

\item{bandprows}{The rows of \code{object$bandp} for which to display p-value results in the plot}

\item{filename}{Filename (without extension), for saving as pdf. Default value NA saves no file and 
uses the default graphics device.}
}
\description{
Plots the \code{ranks} slot for \code{coh} and \code{wlmtest} objects to help identify statistical 
significance of coherence
}
\details{
The plot shows the modulus of \code{object$ranks$coher} versus \code{log(1/object$timescales)}.
Horizontal axis ticks are labeled as timescales, but are spaced on the axis as 
log(1/timescale), i.e., log frequencies. p-values from \code{object$bandp} are displayed
above the rank plot.
}
\examples{
#For a coh object
times<-(-3:100)
ts1<-sin(2*pi*times/10)
ts2<-5*sin(2*pi*times/3)
artsig_x<-matrix(NA,11,length(times)) #the driver
for (counter in 1:11)
{
  artsig_x[counter,]=ts1+ts2+rnorm(length(times),mean=0,sd=1.5)
}
times<-0:100
artsig_y<-matrix(NA,11,length(times)) #the driven
for (counter1 in 1:11)
{
  for (counter2 in 1:101)
  {
    artsig_y[counter1,counter2]<-mean(artsig_x[counter1,counter2:(counter2+2)])
  }
}
artsig_y<-artsig_y+matrix(rnorm(length(times)*11,mean=0,sd=3),11,length(times))
artsig_x<-artsig_x[,4:104]
artsig_x<-cleandat(artsig_x,times,1)$cdat
artsig_y<-cleandat(artsig_y,times,1)$cdat
res<-coh(dat1=artsig_x,dat2=artsig_y,times=times,norm="powall",sigmethod="fast",
nrand=100,f0=0.5,scale.max.input=28)
#use larger nrand for a real application
res<-bandtest(res,c(2,4))
res<-bandtest(res,c(8,12))
plotrank(res)
  
#For a wlmtest object, see vignette

}
\references{
Sheppard, L.W., et al. (2016) Changes in large-scale climate alter spatial synchrony of aphid 
pests. Nature Climate Change. DOI: 10.1038/nclimate2881

Sheppard, LW et al. (2019) Synchrony is more than its top-down and climatic parts: interacting 
Moran effects on phytoplankton in British seas. Plos Computational Biology 15, e1006744. doi: 10.1371/journal.pcbi.1006744
}
\seealso{
\code{\link{coh}}, \code{\link{wlmtest}}, \code{\link{bandtest}}, \code{\link{plotphase}},
\code{\link{plotmag}}, \code{browseVignettes("wsyn")}
}
\author{
Thomas Anderson, \email{anderstl@gmail.com}, Jon Walter, \email{jaw3es@virginia.edu}; Lawrence 
Sheppard, \email{lwsheppard@ku.edu}; Daniel Reuman, \email{reuman@ku.edu}
}
