% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{xQTLdownload_egene}
\alias{xQTLdownload_egene}
\title{Download details of eGenes (eQTL Genes) for a specified gene or a tissue.}
\usage{
xQTLdownload_egene(
  gene = "",
  geneType = "auto",
  tissueSiteDetail = "",
  recordPerChunk = 2000
)
}
\arguments{
\item{gene}{(character) gene symbol or gencode id (versioned or unversioned are both supported).}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{recordPerChunk}{(integer) number of records fetched per request (default: 2000).}
}
\value{
A data.table object.
}
\description{
eGenes are genes that have at least one significant cis-eQTL acting upon them. Results can be filtered by tissue.
}
\examples{
\donttest{
eGeneInfo <- xQTLdownload_egene("TP53")
eGeneInfo <- xQTLdownload_egene(tissueSiteDetail="Prostate", recordPerChunk=2000)
}
}
