% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{theme_xaringan_base}
\alias{theme_xaringan_base}
\title{The ggplot2 xaringanthemer base plot theme}
\usage{
theme_xaringan_base(
  text_color,
  background_color,
  ...,
  set_ggplot_defaults = TRUE,
  accent_color = NULL,
  accent_secondary_color = NULL,
  text_font = NULL,
  text_font_use_google = NULL,
  text_font_size = NULL,
  title_font = NULL,
  title_font_use_google = NULL,
  title_font_size = NULL,
  use_showtext = NULL
)
}
\arguments{
\item{text_color}{Color for text and foreground}

\item{background_color}{Color for background}

\item{...}{Ignored}

\item{set_ggplot_defaults}{Should defaults be set for \pkg{ggplot2} \emph{geoms}?
Defaults to TRUE. To restore ggplot's defaults, or the previously set geom
defaults, see \code{\link[=theme_xaringan_restore_defaults]{theme_xaringan_restore_defaults()}}.}

\item{accent_color}{Color for titles and accents, inherits from
\code{header_color} or \code{text_color}. Used for the \code{title} base setting in
\code{\link[ggplot2:theme]{ggplot2::theme()}}, and additionally for setting the \code{color} or \code{fill} of
\pkg{ggplot2} geom defaults.}

\item{accent_secondary_color}{Color for secondary accents, inherits from
\code{text_bold_color} or \code{accent_color}. Used only when setting \pkg{ggplot2} geom
defaults.}

\item{text_font}{Font to use for text elements, passed to
\code{\link[sysfonts:font_add_google]{sysfonts::font_add_google()}}, if available and \code{text_font_use_google} is
\code{TRUE}. Inherits from \code{text_font_family}. If manually specified, can be a
\code{\link[=google_font]{google_font()}}.}

\item{text_font_use_google}{Is \code{text_font} available on \href{https://fonts.google.com}{Google Fonts}?}

\item{text_font_size}{Base text font size, inherits from \code{text_font_size}, or
defaults to 11.}

\item{title_font}{Font to use for title elements, passed to
\code{\link[sysfonts:font_add_google]{sysfonts::font_add_google()}}, if available and \code{title_font_use_google} is
\code{TRUE}. Inherits from \code{title_font_family}. If manually specified, can be a
\code{\link[=google_font]{google_font()}}.}

\item{title_font_use_google}{Is \code{title_font} available on \href{https://fonts.google.com}{Google Fonts}?}

\item{title_font_size}{Base text font size, inherits from \code{title_font_size},
or defaults to 14.}

\item{use_showtext}{If \code{TRUE} the \pkg{showtext} package will be
used to register Google fonts. Set to \code{FALSE} to disable this feature
entirely, which may result in errors during plotting if the fonts used are
not available locally. The default is \code{TRUE} when the \pkg{showtext}
package is installed.}
}
\value{
A ggplot2 theme
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

Provides a base plot theme for \pkg{ggplot2} to match the \pkg{xaringan}
slide theme created by \link{xaringanthemer}. The theme is designed to create a
general plot style from two colors, a \code{background_color} and a \code{text_color}
(or foreground color). Also accepts an \code{accent_color} and an
\code{accent_secondary_color} that are \link{xaringanthemer} is not required for the
base theme. Use \code{\link[=theme_xaringan]{theme_xaringan()}} or \code{\link[=theme_xaringan_inverse]{theme_xaringan_inverse()}} in xaringan
slides styled by xaringanthemer for a plot theme that matches the slide
style.  See \code{vignette("ggplot2-themes")} for more information and examples.
}
\examples{
# Requires ggplot2
has_ggplot2 <- requireNamespace("ggplot2", quietly = TRUE)

if (has_ggplot2) {
  library(ggplot2)

  plot1 <- ggplot(mpg) +
    aes(cty, hwy) +
    geom_point() +
    theme_xaringan_base(
      text_color = "#602f6b",       # imperial
      background_color = "#f8f8f8", # light gray
      accent_color = "#317873",     # myrtle green
      title_font = "sans",
      text_font = "serif",
      set_ggplot_defaults = TRUE
    ) +
    labs(
      title = "Fuel Efficiency of Various Cars",
      subtitle = "+ theme_xaringan_base()",
      caption = "xaringanthemer"
    )

  print(plot1)

  plot2 <- ggplot(mpg) +
    aes(hwy) +
    geom_histogram(binwidth = 2) +
    theme_xaringan_base(
      text_color = "#a8a9c8",       # light purple
      background_color = "#303163", # deep slate purple
      accent_color = "#ffff99",     # canary yellow
      title_font = "sans",
      text_font = "serif",
      set_ggplot_defaults = TRUE
    ) +
    labs(
      title = "Highway Fuel Efficiency",
      subtitle = "+ theme_xaringan_base()",
      caption = "xaringanthemer"
    )

  print(plot2)
}
}
\seealso{
Other xaringanthemer ggplot2 themes: 
\code{\link{theme_xaringan_inverse}()},
\code{\link{theme_xaringan_set_defaults}()},
\code{\link{theme_xaringan}()}
}
\concept{xaringanthemer ggplot2 themes}
