% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_extra_css.R
\name{style_extra_css}
\alias{style_extra_css}
\title{Add Extra CSS Styles}
\usage{
style_extra_css(
  css,
  outfile = "xaringan-themer.css",
  append = TRUE,
  heading = "Extra CSS"
)
}
\arguments{
\item{css}{A named list of CSS definitions each containing a named list
of CSS property-value pairs, i.e.
\code{list(".class-id" = list("css-property" = "value"))}}

\item{outfile}{Customized xaringan CSS output file name, default is "xaringan-themer.css"}

\item{append}{If \code{TRUE} output will be appended to \code{outfile}; otherwise,
it will overwrite the contents of \code{outfile}.}

\item{heading}{Heading added above extra CSS. Use \code{NULL} to disable.}
}
\description{
Adds css elements to target \code{outfile}, typically a xaringanthemer css file.
The \code{css} argument takes a list of CSS classes and definitions (see examples below)
and appends CSS rules to \code{outfile}.
}
\section{css list}{

The \code{css} input must be a named list of css properties and values within a
named list of class identifiers, for example
\code{list(".class-id" = list("css-property" = "value"))}.
}

\examples{
style_extra_css(
  outfile = stdout(),
  css = list(
    ".red" = list(color = "red"),
    ".small" = list("font-size" = "90\%"),
    ".full-width" = list(
      display = "flex",
      width = "100\%",
      flex = "1 1 auto"
    )
  )
)
}
