/*
 * Decompiled with CFR 0.152.
 */
package org.cran.rexcel;

import java.util.HashMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.cran.rexcel.RInterface;

public class RCellBlock {
    public int noRows;
    public int noCols;
    private Cell[][] cells;

    public RCellBlock(Sheet sheet, int startRowIndex, int startColIndex, int nRows, int nCols, boolean create) {
        this.cells = new Cell[nCols][nRows];
        this.noRows = nRows;
        this.noCols = nCols;
        int i = 0;
        while (i < nRows) {
            Row r = sheet.getRow(startRowIndex + i);
            if (r == null) {
                if (create) {
                    r = sheet.createRow(startRowIndex + i);
                } else {
                    throw new RuntimeException("Row does " + (startRowIndex + i) + "not exist in the sheet");
                }
            }
            int j = 0;
            while (j < nCols) {
                this.cells[j][i] = create ? r.createCell(startColIndex + j) : r.getCell(startColIndex + j);
                ++j;
            }
            ++i;
        }
    }

    public Cell getCell(int rowIndex, int colIndex) {
        return this.cells[colIndex][rowIndex];
    }

    public Sheet getSheet() {
        return this.cells != null & this.cells.length >= 1 & this.cells[0] != null & this.cells[0].length >= 1 & this.cells[0][0] != null ? this.cells[0][0].getSheet() : null;
    }

    public Workbook getWorkbook() {
        Sheet sheet = this.getSheet();
        return sheet != null ? sheet.getWorkbook() : null;
    }

    public boolean isXSSF() {
        return this.getSheet() instanceof XSSFSheet;
    }

    public void setColData(int colIndex, int rowOffset, double[] data, boolean showNA, CellStyle style) {
        Cell[] colCells = this.cells[colIndex];
        int i = 0;
        while (i < data.length) {
            if (showNA || !RInterface.isNA(data[i])) {
                colCells[rowOffset + i].setCellValue(data[i]);
            } else {
                colCells[rowOffset + i].setCellType(3);
            }
            if (style != null) {
                this.setCellStyle(style, rowOffset + i, colIndex);
            }
            ++i;
        }
    }

    public void setColData(int colIndex, int rowOffset, int[] data, boolean showNA, CellStyle style) {
        Cell[] colCells = this.cells[colIndex];
        int i = 0;
        while (i < data.length) {
            if (showNA || !RInterface.isNA(data[i])) {
                colCells[rowOffset + i].setCellValue((double)data[i]);
            } else {
                colCells[rowOffset + i].setCellType(3);
            }
            if (style != null) {
                this.setCellStyle(style, rowOffset + i, colIndex);
            }
            ++i;
        }
    }

    public void setColData(int colIndex, int rowOffset, String[] data, boolean showNA, CellStyle style) {
        Cell[] colCells = this.cells[colIndex];
        int i = 0;
        while (i < data.length) {
            if (showNA || !RInterface.isNA(data[i])) {
                colCells[rowOffset + i].setCellValue(data[i]);
            } else {
                colCells[rowOffset + i].setCellType(3);
            }
            if (style != null) {
                this.setCellStyle(style, rowOffset + i, colIndex);
            }
            ++i;
        }
    }

    public void setRowData(int rowIndex, int colOffset, String[] data, boolean showNA, CellStyle style) {
        int i = 0;
        while (i < data.length) {
            if (showNA || !RInterface.isNA(data[i])) {
                this.cells[colOffset + i][rowIndex].setCellValue(data[i]);
            } else {
                this.cells[colOffset + i][rowIndex].setCellType(3);
            }
            if (style != null) {
                this.setCellStyle(style, rowIndex, colOffset + i);
            }
            ++i;
        }
    }

    public void setMatrixData(int startRow, int endRow, int startColumn, int endColumn, double[] data, boolean showNA, CellStyle style) {
        int j = startColumn;
        while (j <= endColumn) {
            int i = startRow;
            while (i <= endRow) {
                if (showNA || !RInterface.isNA(data[i])) {
                    this.cells[j][i].setCellValue(data[(endRow - startRow + 1) * (j - startColumn) + (i - startRow)]);
                } else {
                    this.cells[j][i].setCellType(3);
                }
                if (style != null) {
                    this.setCellStyle(style, i, j);
                }
                ++i;
            }
            ++j;
        }
    }

    public void setColCellStyle(CellStyle style, int colIndex, int rowOffset, int length) {
        Cell[] colCells = this.cells[colIndex];
        int i = 0;
        while (i < length) {
            colCells[rowOffset + i].setCellStyle(style);
            ++i;
        }
    }

    public void setRowCellStyle(CellStyle style, int rowIndex, int colOffset, int length) {
        int i = 0;
        while (i < length) {
            this.cells[colOffset + i][rowIndex].setCellStyle(style);
            ++i;
        }
    }

    public void setCellStyle(CellStyle style, int[] rowIndices, int[] colIndices) {
        int[] nArray = colIndices;
        int n = colIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int colIx = nArray[n2];
            Cell[] colCells = this.cells[colIx];
            int[] nArray2 = rowIndices;
            int n3 = rowIndices.length;
            int n4 = 0;
            while (n4 < n3) {
                int rowIx = nArray2[n4];
                colCells[rowIx].setCellStyle(style);
                ++n4;
            }
            ++n2;
        }
    }

    private void setCellStyle(CellStyle style, int rowIx, int colIx) {
        this.cells[colIx][rowIx].setCellStyle(style);
    }

    public void setCellStyle(CellStyle style) {
        Cell[][] cellArray = this.cells;
        int n = this.cells.length;
        int n2 = 0;
        while (n2 < n) {
            Cell[] colCells;
            Cell[] cellArray2 = colCells = cellArray[n2];
            int n3 = colCells.length;
            int n4 = 0;
            while (n4 < n3) {
                Cell cell = cellArray2[n4];
                cell.setCellStyle(style);
                ++n4;
            }
            ++n2;
        }
    }

    protected void modifyCellStyle(int[] rowIndices, int[] colIndices, CellStyleModifier modifier) {
        if (rowIndices.length != colIndices.length) {
            throw new RuntimeException("Length of indRows should equal length of indCols!");
        }
        HashMap<Short, CellStyle> styleMap = new HashMap<Short, CellStyle>();
        CellStyle defaultStyle = null;
        int i = 0;
        while (i < colIndices.length) {
            Cell cell = this.cells[colIndices[i]][rowIndices[i]];
            CellStyle style = cell.getCellStyle();
            if (style == null) {
                if (defaultStyle == null) {
                    defaultStyle = this.getWorkbook().createCellStyle();
                    modifier.modify(defaultStyle);
                }
                cell.setCellStyle(defaultStyle);
            } else if (styleMap.containsKey(style.getIndex())) {
                cell.setCellStyle((CellStyle)styleMap.get(style.getIndex()));
            } else {
                CellStyle modStyle = this.getWorkbook().createCellStyle();
                modStyle.cloneStyleFrom(style);
                modifier.modify(modStyle);
                styleMap.put(style.getIndex(), modStyle);
                cell.setCellStyle(modStyle);
            }
            ++i;
        }
    }

    public void setFill(final short foreground, final short background, final short pattern, int[] rowIndices, int[] colIndices) {
        this.modifyCellStyle(rowIndices, colIndices, new CellStyleModifier(){

            public void modify(CellStyle style) {
                style.setFillPattern(pattern);
                style.setFillForegroundColor(foreground);
                style.setFillBackgroundColor(background);
            }
        });
    }

    public void setFill(final XSSFColor foreground, final XSSFColor background, final short pattern, int[] rowIndices, int[] colIndices) {
        this.modifyCellStyle(rowIndices, colIndices, new CellStyleModifier(){

            public void modify(CellStyle style) {
                style.setFillPattern(pattern);
                if (!(style instanceof XSSFCellStyle)) {
                    throw new RuntimeException("Current cell style doesn't support XSSF colors");
                }
                XSSFCellStyle xssfStyle = (XSSFCellStyle)style;
                xssfStyle.setFillForegroundColor(foreground);
                xssfStyle.setFillBackgroundColor(background);
            }
        });
    }

    public void setFont(final Font font, int[] rowIndices, int[] colIndices) {
        this.modifyCellStyle(rowIndices, colIndices, new CellStyleModifier(){

            public void modify(CellStyle style) {
                style.setFont(font);
            }
        });
    }

    public void putBorder(final short borderTop, final short topBorderColor, final short borderBottom, final short bottomBorderColor, final short borderLeft, final short leftBorderColor, final short borderRight, final short rightBorderColor, int[] rowIndices, int[] colIndices) {
        this.modifyCellStyle(rowIndices, colIndices, new CellStyleModifier(){

            public void modify(CellStyle style) {
                if (borderTop != 0) {
                    style.setBorderTop(borderTop);
                    style.setTopBorderColor(topBorderColor);
                }
                if (borderBottom != 0) {
                    style.setBorderBottom(borderBottom);
                    style.setBottomBorderColor(bottomBorderColor);
                }
                if (borderLeft != 0) {
                    style.setBorderLeft(borderLeft);
                    style.setLeftBorderColor(leftBorderColor);
                }
                if (borderRight != 0) {
                    style.setBorderRight(borderRight);
                    style.setRightBorderColor(rightBorderColor);
                }
            }
        });
    }

    public void putBorder(final short borderTop, final XSSFColor topBorderColor, final short borderBottom, final XSSFColor bottomBorderColor, final short borderLeft, final XSSFColor leftBorderColor, final short borderRight, final XSSFColor rightBorderColor, int[] rowIndices, int[] colIndices) {
        this.modifyCellStyle(rowIndices, colIndices, new CellStyleModifier(){

            public void modify(CellStyle style) {
                if (style instanceof XSSFCellStyle) {
                    XSSFCellStyle xssfStyle = (XSSFCellStyle)style;
                    if (borderTop != 0) {
                        xssfStyle.setBorderTop(borderTop);
                        xssfStyle.setTopBorderColor(topBorderColor);
                    }
                    if (borderBottom != 0) {
                        xssfStyle.setBorderBottom(borderBottom);
                        xssfStyle.setBottomBorderColor(bottomBorderColor);
                    }
                    if (borderLeft != 0) {
                        xssfStyle.setBorderLeft(borderLeft);
                        xssfStyle.setLeftBorderColor(leftBorderColor);
                    }
                    if (borderRight != 0) {
                        xssfStyle.setBorderRight(borderRight);
                        xssfStyle.setRightBorderColor(rightBorderColor);
                    }
                } else {
                    throw new RuntimeException("Current cell style doesn't support XSSF colors");
                }
            }
        });
    }

    protected static interface CellStyleModifier {
        public void modify(CellStyle var1);
    }
}

