% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose_set.R
\name{expose_param}
\alias{expose_param}
\title{Expose a model parameter of xpdb objects in an xpose_set}
\usage{
expose_param(xpdb_s, ..., .problem = NULL, .subprob = NULL, .method = NULL)
}
\arguments{
\item{xpdb_s}{<\code{\link{xpose_set}}> An xpose_set object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> One or more parameter
to expose, using selection rules from \code{\link{add_prm_association}}.}

\item{.problem}{<\code{numeric}> Problem number to apply this relationship.}

\item{.subprob}{<\code{numeric}> Problem number to apply this relationship.}

\item{.method}{<\code{numeric}> Problem number to apply this relationship.}
}
\value{
An \code{xpose_set} object with the parameter exposed
}
\description{
Expose a model parameter of xpdb objects in an xpose_set
}
\details{
The parameter returned will be top-level, and to avoid conflicting
names will be prepended by \code{..} (e.g., \code{..ome1}). The selector
used to fetch the parameter will be used in this \code{..} name. If
a better name is preferred, there are convenient renaming functions
from \code{dplyr} where needed.

When using parameter selectors, quotations should be used for more
complex names, like \code{"OMEGA(1,1)"}, since these may be read incorrectly
otherwise.

The untransformed parameter is used for this exposure. The \code{get_prm}
call uses \code{transform=FALSE}.
}
\examples{

pheno_set \%>\%
  expose_param(the1) \%>\%
  reshape_set()


pheno_set \%>\%
  expose_param(RUVADD, "OMEGA(1,1)") \%>\%
  reshape_set()

# This function is useful for generating a model-building table
pheno_set \%>\%
  # Determine longest lineage
  select(all_of(xset_lineage(.))) \%>\%
  # Select key variability parameters
  expose_param(RUVADD, "OMEGA(1,1)") \%>\%
  # Make sure all models have descriptions
  focus_qapply(desc_from_comments) \%>\%
  # Extract description
  expose_property(descr) \%>\%
  # Transform to tibble
  reshape_set() # \%>\% pipe into other processing

}
\seealso{
\code{\link[=expose_property]{expose_property()}}
}
