% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpdb_edits.R
\name{modify_xpdb}
\alias{modify_xpdb}
\alias{mutate.xpose_data}
\alias{modify_xpdb}
\alias{select.xpose_data}
\alias{modify_xpdb}
\alias{rename.xpose_data}
\title{Add, remove or rename variables in an xpdb}
\usage{
\method{mutate}{xpose_data}(.data, ..., .problem, .source, .where)

\method{select}{xpose_data}(.data, ..., .problem, .source, .where)

\method{rename}{xpose_data}(.data, ..., .problem, .source, .where)
}
\arguments{
\item{.data}{An xpose database object.}

\item{...}{Name-value pairs of expressions. Use \code{NULL} to drop a variable.

These arguments are automatically quoted and evaluated in the 
context of the data frame. They support unquoting and splicing. 
See the dplyr vignette("programming") for an introduction to these concepts.}

\item{.problem}{The problem from which the data will be modified}

\item{.source}{The source of the data in the xpdb. Can either be 'data' or an output 
file extension e.g. 'phi'.}

\item{.where}{A vector of element names to be edited in special (e.g. 
\code{.where = c('vpc_dat', 'aggr_obs')} with vpc).}
}
\description{
\code{mutate()} adds new variables and preserves existing ones. 
\code{select()} keeps only the listed variables; \code{rename()} keeps all variables.
}
\examples{
# Mutate columns
xpdb_ex_pk \%>\% 
 mutate(lnDV = log(DV), 
        sim_count = irep(ID), 
        .problem = 1) \%>\% 
 dv_vs_idv(aes(y = lnDV))
 
# Rename/select columns
xpdb_ex_pk \%>\% 
 select(ID:TAD, DV, EVID) \%>\% 
 rename(TSLD = TAD) \%>\% 
 dv_vs_idv(aes(x = TSLD))
}
