% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpdb_access.R
\name{get_summary}
\alias{get_summary}
\title{Access model summary data}
\usage{
get_summary(xpdb, .problem = NULL, .subprob = NULL, only_last = FALSE)
}
\arguments{
\item{xpdb}{An \code{xpose_data} object from which the summary data will be extracted.}

\item{.problem}{The .problem to be used, by default returns the last one for each label.}

\item{.subprob}{The subproblem to be used, by default returns the last one for each label.}

\item{only_last}{Logical, if \code{TRUE} only the last record for each label is returned in case 
of multiple problem and/or subproblem. If \code{FALSE} all values are returned.}
}
\value{
A tibble of model summary.
}
\description{
Access model summary data from an xpdb object.
}
\examples{
run_summary <- get_summary(xpdb_ex_pk)
run_summary

}
\seealso{
\code{\link{xpose_data}}, \code{\link{template_titles}}, \code{\link{summary.xpose_data}}
}
