% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.xlabel.R
\name{change.xlabel}
\alias{change.xlabel}
\title{Changes the label of an Xpose data item}
\usage{
change.xlabel(object, listall = TRUE, classic = FALSE)
}
\arguments{
\item{object}{An \code{xpose.data} object.}

\item{listall}{A logical operator specifying whether the items in the
database should be listed.}

\item{classic}{A logical operator specifying whether the function should
assume the classic menu system. This is an internal option and need never be
called from the command line.}
}
\value{
An \code{\link{xpose.data}} object.
}
\description{
This function allows the labels of data items in the Xpose database to be
changed.
}
\details{
This function facilitates the changing of data item labels in the
object@Prefs@Labels slot.
}
\examples{

\dontrun{
## xpdb5 is an Xpose data object
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory
xpdb5 <- xpose.data(5)

xpdb5 <- change.xlabel(xpdb5)
}

}
\seealso{
\code{\link{Data}},\code{\link{SData}},\code{\link{xpose.data}}
}
\author{
Justin Wilkins
}
\keyword{methods}
