% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.ab.graph.par.R, R/change.bw.graph.par.R,
%   R/change.cond.graph.par.R, R/change.dil.graph.par.R, R/change.label.par.R,
%   R/change.lm.graph.par.R, R/change.misc.graph.par.R, R/change.pi.graph.par.R,
%   R/change.smooth.graph.par.R
\name{change_graphical_parameters}
\alias{change_graphical_parameters}
\alias{change.ab.graph.par}
\alias{change.bw.graph.par}
\alias{change.cond.graph.par}
\alias{change.dil.graph.par}
\alias{change.label.par}
\alias{change.lm.graph.par}
\alias{change.misc.graph.par}
\alias{change.pi.graph.par}
\alias{change.smooth.graph.par}
\title{Functions changing variable definitions in Xpose 4}
\usage{
change.ab.graph.par(object, classic = FALSE)

change.bw.graph.par(object, classic = FALSE)

change.cond.graph.par(object, classic = FALSE)

change.dil.graph.par(object, classic = FALSE)

change.label.par(object, classic = FALSE)

change.lm.graph.par(object, classic = FALSE)

change.misc.graph.par(object, classic = FALSE)

change.pi.graph.par(object, classic = FALSE)

change.smooth.graph.par(object, classic = FALSE)
}
\arguments{
\item{object}{An \code{xpose.data} object.}

\item{classic}{A logical operator specifying whether the function should
assume the classic menu system. This is an internal option and need never be
called from the command line.}
}
\value{
An \code{\link{xpose.data}} object (classic == FALSE) or null
(classic == TRUE).
}
\description{
These functions allow customization of Xpose's graphics settings.
}
\details{
Settings can be saved and loaded using \code{\link{export.graph.par}} and
\code{\link{import.graph.par}}, respectively.
}
\section{Functions}{
\itemize{
\item \code{change.ab.graph.par}: change settings for the line of
identity.

\item \code{change.bw.graph.par}: sets preferences for box-and-whisker plots

\item \code{change.cond.graph.par}: sets preferences for conditioning

\item \code{change.dil.graph.par}: responsible for dilution
preferences

\item \code{change.label.par}: responsible for labelling preferences

\item \code{change.lm.graph.par}: responsible for linear regression
lines.

\item \code{change.misc.graph.par}: sets basic graphics parameters,
including plot type, point type and size, colour, line type, and line width.

\item \code{change.pi.graph.par}: responsible for prediction interval plotting preferences

\item \code{change.smooth.graph.par}: sets preferences for loess smooths.
}}

\examples{

\dontrun{
## xpdb5 is an Xpose data object
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory
xpdb5 <- xpose.data(5)

## Change default miscellaneous graphic preferences
xpdb5 <- change.misc.graph.par(xpdb5)

## Change default linear regression line preferences, creating a new 
## object
xpdb5.a <- change.lm.graph.par(xpdb5)

## Change conditioning preferences
xpdb5 <- change.cond.graph.par(xpdb5)
}


}
\seealso{
\code{\link{xpose.plot.default}},\code{\link{xpose.panel.default}},
\code{\link{xpose.plot.bw}},\code{\link{xpose.panel.bw}},
\code{\link{xpose.plot.default}},\code{\link{import.graph.par}},
\code{\link{export.graph.par}},\code{\link{plot.default}},
\code{\link{par}},\code{\link{import.graph.par}},\code{\link[lattice]{panel.abline}},
\code{\link[lattice]{panel.lmline}},\code{\link{lm}},\code{\link[lattice]{panel.loess}},
\code{\link{loess.smooth}},\code{\link{loess}},\code{\link[lattice]{panel.bwplot}},
\code{\link[lattice]{shingle}},\code{reorder.factor}

Other data functions: 
\code{\link{add_transformed_columns}},
\code{\link{change_misc_parameters}},
\code{\link{compute.cwres}()},
\code{\link{data.checkout}()},
\code{\link{data_extract_or_assign}},
\code{\link{db.names}()},
\code{\link{export.graph.par}()},
\code{\link{export.variable.definitions}()},
\code{\link{import.graph.par}()},
\code{\link{import.variable.definitions}()},
\code{\link{make.sb.data}()},
\code{\link{nsim}()},
\code{\link{par_cov_summary}},
\code{\link{read.TTE.sim.data}()},
\code{\link{read.nm.tables}()},
\code{\link{read_NM_output}},
\code{\link{read_nm_table}()},
\code{\link{simprazExample}()},
\code{\link{tabulate.parameters}()},
\code{\link{xlabel}()},
\code{\link{xpose.data}},
\code{\link{xpose.print}()},
\code{\link{xpose4-package}},
\code{\link{xsubset}()}
}
\author{
Niclas Jonsson & Justin Wilkins
}
\concept{data functions}
