% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_tune_xrnet.R
\name{predict.tune_xrnet}
\alias{predict.tune_xrnet}
\title{Predict function for "tune_xrnet" object}
\usage{
\method{predict}{tune_xrnet}(
  object,
  newdata = NULL,
  newdata_fixed = NULL,
  p = "opt",
  pext = "opt",
  type = c("response", "link", "coefficients"),
  ...
)
}
\arguments{
\item{object}{A \code{\link{tune_xrnet}} object}

\item{newdata}{matrix with new values for penalized variables}

\item{newdata_fixed}{matrix with new values for unpenalized variables}

\item{p}{vector of penalty values to apply to predictor variables.
Default is optimal value in tune_xrnet object.}

\item{pext}{vector of penalty values to apply to external data variables.
Default is optimal value in tune_xrnet object.}

\item{type}{type of prediction to make using the xrnet model, options include:
\itemize{
   \item response
   \item link (linear predictor)
   \item coefficients
}}

\item{...}{pass other arguments to xrnet function (if needed)}
}
\value{
The object returned is based on the value of type as follows:
\itemize{
    \item response: An array with the response predictions based on the data for each penalty combination
    \item link: An array with linear predictions based on the data for each penalty combination
    \item coefficients: A list with the coefficient estimates for each penalty combination. See \code{\link{coef.xrnet}}.
}
}
\description{
Extract coefficients or predict response in new data using fitted model from a \code{\link{tune_xrnet}} object.
Note that we currently only support returning results that are in the original path(s).
}
\examples{
data(GaussianExample)

## 5-fold cross validation
cv_xrnet <- tune_xrnet(
    x = x_linear,
    y = y_linear,
    external = ext_linear,
    family = "gaussian",
    control = xrnet.control(tolerance = 1e-6)
 )

## Get coefficients and predictions at optimal penalty combination
coef_xrnet <- predict(cv_xrnet, type = "coefficients")
pred_xrnet <- predict(cv_xrnet, newdata = x_linear, type = "response")

}
