% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.xtune.R
\name{predict_xtune}
\alias{predict_xtune}
\title{Model predictions based on fitted \code{xtune} object}
\usage{
predict_xtune(object, newX, type = c("response", "class"), ...)
}
\arguments{
\item{object}{Fitted 'xtune' model object.}

\item{newX}{Matrix of values at which predictions are to be made.}

\item{type}{Type of prediction required. For "linear" models it gives the fitted values. Type "response" gives the fitted probability scores of each category for "binary" or "multiclass" outcome.  Type "class" applies to "binary" or "multiclass" models, and produces the class label corresponding to the maximum probability.}

\item{...}{Not used}
}
\value{
A vector of predictions
}
\description{
\code{predict_xtune} produces predicted values fitting an xtune model to a new dataset
}
\details{
\code{coef} and \code{predict} methods are provided as a convenience to extract coefficients and make prediction. \code{predict_xtune} simply calculate the predicted value using the estimated coefficients returned by \code{xtune}.
}
\examples{

## If no Z provided, perform Empirical Bayes tuning
## simulate linear data
set.seed(9)
data(example)
X <- example$X
Y <- example$Y
Z <- example$Z

\donttest{
fit.eb <- xtune(X,Y)
coef_xtune(fit.eb)
predict_xtune(fit.eb,X)
}


## Feature specific shrinkage based on external information Z:

## simulate multi-categorical data
data(example.multiclass)
X <- example.multiclass$X
Y <- example.multiclass$Y
Z <- example.multiclass$Z
\donttest{
fit <- xtune(X,Y,Z,family = "multiclass")


## Coef and predict methods
coef_xtune(fit)
predict_xtune(fit,X, type = "class")
}
}
\seealso{
\code{xtune}, \code{coef_xtune}
}
