# xvm: An R Package for Reading, Parsing, and Visualizing xvg and xpm Files

`xvm` is an R package that provides tools for reading, parsing, and visualizing output files in xvg and xpm formats, which are typically generated by simulation software such as GROMACS. `xvm` is designed to streamline the post-processing and analysis of molecular dynamics (MD) simulation data. With `xvm`, users can easily import trajectory data (e.g., RMSD, energy, temperature) and generate publication-quality plots. Targeted at researchers in computational chemistry, biophysics, and structural biology, xvm bridges the gap between raw MD outputs and actionable insights, enabling the efficient exploration of molecular stability and conformational changes.

---

Find out more at [https://github.com/RightSZ/xvm](https://github.com/RightSZ/xvm)

## Installation

install the latest version from [GitHub](https://github.com/RightSZ/xvm) as follow:

```r
# Install the development version from GitHub
if(!require(devtools)) install.packages("devtools")
devtools::install_github("RightSZ/xvm")
```

## Run xvg example

```r
# Load the xvm package
library(xvm)

# This example file is an xvg file containing RMSD data generated by GROMACS
rmsd_file_path <- system.file("extdata/rmsd.xvg", package = "xvm")

# Read the xvg file using read_xvg() function
rmsd_data <- read_xvg(rmsd_file_path)

# The imported xvg file is stored as a list, with the list name corresponding to the file name.
names(rmsd_data)

# Plot the xvg data using plot_xvg() function
plot_xvg(rmsd_data)
```

## Run xpm example

```r
# This example file is an xpm file containing (free energy landscape, FEL) data generated by GROMACS
gibbs_file_path <- system.file("extdata/gibbs.xpm", package = "xvm")

# Read the xpm file using read_xpm() function
gibbs_data <- read_xpm(gibbs_file_path)

# The imported xpm file is stored as a list, with the list name corresponding to the file name.
names(gibbs_data)

# Plot the xpm data using plot_xpm() function
plot_xpm(gibbs_data)
```
