% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dvec.R
\name{as_dvec.units}
\alias{as_dvec.units}
\title{Coerce Units to Decorated Vector}
\usage{
\method{as_dvec}{units}(x, ...)
}
\arguments{
\item{x}{units}

\item{...}{passed arguments}
}
\description{
Coerces units to dvec.
}
\examples{
library(magrittr)
library(dplyr)
a <- data.frame(id = 1:4, wt = c(70, 80, 70, 80), sex = c(0,1,0,1))
a \%<>\% decorate('wt: [ body weight, kg ]')
a \%<>\% decorate('sex: [ sex, [ female: 0, male: 1]]')
a \%<>\% decorate('id: identifier')
a \%<>\% resolve
a \%<>\% mutate(wt = as_units(wt))
a \%<>\% mutate(wt = as_dvec(wt))
str(a$wt)
}
\keyword{internal}
