% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singularity.R
\name{[.decorated}
\alias{[.decorated}
\title{a <- as_decorated(as.list(setNames(letters[1:3], LETTERS[1:3])))
attr(a$B, 'label') <- 'foo'
a <- a[1:3]
attributes(a)
Subset Decorated}
\usage{
\method{[}{decorated}(x, ..., .promote = getOption("yamlet_promote", TRUE))
}
\arguments{
\item{x}{decorated}

\item{...}{passed to next method}

\item{.promote}{whether to auto-promote plural attributes}
}
\value{
decorated (unless dimension is dropped)
}
\description{
Subsets decorated. Calls \code{\link{promote}}
internally to improve ambiguous conditional
attributes where possible.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','phenobarb.csv')
x <- file \%>\% decorate
x \%>\% decorations(event, value)

# Subsetting promotes automatically.
x[x$event == 'dose',] \%>\% decorations(event, value)
x[x$event == 'conc',] \%>\% decorations(event, value)

# Dimension may be dropped
x[1,1]

# Conventional subsetting
a <- as_decorated(as.list(setNames(letters[1:3], LETTERS[1:3])))
attr(a$B, 'label') <- 'foo'
a <- a[1:3]
attributes(a)

}
\seealso{
Other promote: 
\code{\link{filter.decorated}()},
\code{\link{promote}()},
\code{\link{promote.data.frame}()},
\code{\link{promote.list}()},
\code{\link{singularity}()}

Other decorated: 
\code{\link{[<-.decorated}()},
\code{\link{[[.decorated}()},
\code{\link{[[<-.decorated}()},
\code{\link{merge.decorated}()},
\code{\link{names<-.decorated}()}
}
\concept{decorated}
\concept{promote}
\keyword{internal}
