% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_tree.R
\name{draw_yml_tree}
\alias{draw_yml_tree}
\title{Draw an tree of YAML hierarchy}
\usage{
draw_yml_tree(.yml = last_yml(), indent = "")
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \code{yml_*()} function}

\item{indent}{a character vector used to indent the tree}
}
\value{
invisibly, \code{.yml}
}
\description{
\code{draw_yml_tree()} draws an ASCII tree of the hierarchy of a given \code{yml}
object to the console.
}
\examples{
# draw the most recently used `yml`
draw_yml_tree()
\donttest{
yml() \%>\%
  yml_output(
    pdf_document(keep_tex = TRUE),
    html_document()
  ) \%>\%
    draw_yml_tree()
}
}
\seealso{
Other yml: \code{\link{asis_yaml_output}},
  \code{\link{bib2yml}}, \code{\link{has_field}},
  \code{\link{read_json}}, \code{\link{use_yml_defaults}},
  \code{\link{use_yml_file}}, \code{\link{use_yml}},
  \code{\link{yml_author}},
  \code{\link{yml_blogdown_opts}},
  \code{\link{yml_bookdown_opts}},
  \code{\link{yml_citations}}, \code{\link{yml_clean}},
  \code{\link{yml_distill_opts}},
  \code{\link{yml_latex_opts}}, \code{\link{yml_output}},
  \code{\link{yml_pagedown_opts}},
  \code{\link{yml_params}}, \code{\link{yml_pkgdown}},
  \code{\link{yml_reference}}, \code{\link{yml_replace}},
  \code{\link{yml_resource_files}},
  \code{\link{yml_rsconnect_email}},
  \code{\link{yml_rticles_opts}},
  \code{\link{yml_runtime}}, \code{\link{yml_site_opts}},
  \code{\link{yml_toc}}, \code{\link{yml_vignette}}
}
\concept{yml}
