% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imp_assert.R
\name{assertions}
\alias{assertions}
\alias{imp_assert_integer}
\alias{imp_assert_int}
\alias{imp_assert_double}
\alias{imp_assert_dbl}
\alias{imp_assert_numeric}
\alias{imp_assert_num}
\alias{imp_assert_logical}
\alias{imp_assert_lgl}
\alias{imp_assert_character}
\alias{imp_assert_chr}
\alias{imp_assert_data_frame}
\alias{imp_assert_list}
\alias{imp_assert_scalar_integer}
\alias{imp_assert_scalar_int}
\alias{imp_assert_scalar_double}
\alias{imp_assert_scalar_dbl}
\alias{imp_assert_scalar_numeric}
\alias{imp_assert_scalar_num}
\alias{imp_assert_scalar_logical}
\alias{imp_assert_scalar_lgl}
\alias{imp_assert_bool}
\alias{imp_assert_boolean}
\alias{imp_assert_scalar_character}
\alias{imp_assert_scalar_chr}
\alias{imp_assert_string}
\title{Argument assertions}
\usage{
imp_assert_integer(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_int(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_double(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_dbl(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_numeric(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_num(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_logical(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_lgl(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_character(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_chr(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_data_frame(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_list(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_scalar_integer(
  x,
  arg = deparse(substitute(x)),
  call = sys.call(-1L)
)

imp_assert_scalar_int(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_scalar_double(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_scalar_dbl(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_scalar_numeric(
  x,
  arg = deparse(substitute(x)),
  call = sys.call(-1L)
)

imp_assert_scalar_num(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_scalar_logical(
  x,
  arg = deparse(substitute(x)),
  call = sys.call(-1L)
)

imp_assert_scalar_lgl(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_bool(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_boolean(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_scalar_character(
  x,
  arg = deparse(substitute(x)),
  call = sys.call(-1L)
)

imp_assert_scalar_chr(x, arg = deparse(substitute(x)), call = sys.call(-1L))

imp_assert_string(x, arg = deparse(substitute(x)), call = sys.call(-1L))
}
\arguments{
\item{x}{Argument to check.}

\item{arg}{Name of argument being checked (used in error message).}

\item{call}{Call to use in error message.}
}
\value{
The input argument (invisibly) if the assertion succeeds (error
otherwise).
}
\description{
Assertions for function arguments. Motivated by \code{vctrs::vec_assert()} but
with lower overhead at a cost of less informative error messages. Designed to
make it easy to identify the top level calling function whether used within a
user facing function or internally.
}
\examples{

# Use in a user facing function
fun <- function(i, d, l, chr, b) {
    imp_assert_scalar_int(i)
    TRUE
}
fun(i=1L)
try(fun())
try(fun(i="cat"))

# Use in an internal function
internal_fun <- function(a) {
    imp_assert_string(a, arg = deparse(substitute(a)), call = sys.call(-1L))
    TRUE
}
external_fun <- function(b) {
    internal_fun(a=b)
}
external_fun(b="cat")
try(external_fun())
try(external_fun(a = letters))

}
