% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greprows.R
\name{greprows}
\alias{greprows}
\title{Pattern matching on data frame rows}
\usage{
greprows(
  dat,
  pattern,
  cols = NULL,
  value = TRUE,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  invert = FALSE
)
}
\arguments{
\item{dat}{Data frame}

\item{pattern}{character string containing a \link[base]{regular expression}
    (or character string for \code{fixed = TRUE}) to be matched
    in the given character vector.  Coerced by
    \code{\link[base]{as.character}} to a character string if possible.  If a
    character vector of length 2 or more is supplied, the first element
    is used with a warning.  Missing values are allowed except for
    \code{regexpr}, \code{gregexpr} and \code{regexec}.}

\item{cols}{\verb{[character]}

Character vector of columns to search.

If \code{NULL} (default) all character and factor columns will be searched.}

\item{value}{\verb{[logical]}

Should a data frame of rows be returned.

If \code{FALSE} row indices will be returned instead of the rows themselves.}

\item{ignore.case}{if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}

\item{perl}{logical.  Should Perl-compatible regexps be used?}

\item{fixed}{logical.  If \code{TRUE}, \code{pattern} is a string to be
    matched as is.  Overrides all conflicting arguments.}

\item{invert}{logical.  If \code{TRUE} return indices or values for
    elements that do \emph{not} match.}
}
\value{
A data frame of the corresponding rows or, if \code{value = FALSE}, the
corresponding row numbers.
}
\description{
\code{greprows()} searches for pattern matches within a data frames columns and
returns the related rows or row indices.
}
\examples{

dat <- data.frame(
    first = letters,
    second = factor(rev(LETTERS)),
    third = "Q"
)
greprows(dat, "A|b")
greprows(dat, "A|b", ignore.case = TRUE)
greprows(dat, "c", value = FALSE)


}
\seealso{
grep
}
