% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chip.R
\name{chipInput}
\alias{chipInput}
\alias{updateChipInput}
\title{Chip inputs}
\usage{
chipInput(
  id,
  choices = NULL,
  values = choices,
  selected = NULL,
  ...,
  placeholder = NULL,
  max = Inf,
  inline = TRUE,
  sort = "stack"
)

updateChipInput(
  id,
  choices = NULL,
  values = choices,
  selected = NULL,
  max = NULL,
  enable = NULL,
  disable = NULL,
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{choices}{A character vector or list specifying the possible choices.}

\item{values}{A character vector or list of strings specifying the input's
values, defaults to \code{choices}.}

\item{selected}{One or more of \code{values} specifying which values are selected
by default.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{placeholder}{A character string specifying placeholder text of the
chip input, defaults to \code{NULL}.}

\item{max}{A number specifying the maximum number of items a user may select,
defaults to \code{Inf}.}

\item{inline}{One of \code{TRUE} or \code{FALSE} specifying if chips are rendered
inline. If \code{TRUE} multiple chips may fit onto a single row, otherwise, if
\code{FALSE}, chips expand to fill the width of their parent element, one chip
per row.}

\item{sort}{One of \code{"stack"}, \code{"queue"}, or \code{"fixed"} specifying how
selected chips are ordered, defaults to \code{"stack"}.

\code{"stack"}, selected chips are placed ahead of other selected chips.

\code{"queue"}, selected chips are placed behind other selected chips.

\code{"fixed"}, selected chips appear in the order specified by
\code{choices} and \code{values}. Use \code{"fixed"} and sort \code{choices} to keep selected
chips in the same sorted order.}

\item{enable}{One of \code{values} specifying particular choices to enable or
\code{TRUE} specifying the entire input is enabled, defaults to \code{NULL}.}

\item{disable}{One of \code{values} specifying particular choices to disable or
\code{TRUE} specifying the entire input is disabled, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
The chip input is a selectize alternative. Choices are selected from a
dropdown menu and appear as chips below the input's text box. Chips do not
appear in the order they are selected. Instead chips are shown in the order
specified by the \code{choices} argument. Use the \code{max} argument to limit the
number of choices a user may select.
}
\section{\strong{Example} simple application}{
\if{html}{\out{<div class="R">}}\preformatted{ui <- container(
  chipInput(
    id = "chips",
    choices = paste("Option number", 1:10),
    values = 1:10,
    inline = TRUE
  ) \%>\%
    width("1/2")
)

server <- function(input, output) \{

\}

shinyApp(ui, server)
}\if{html}{\out{</div>}}
}

\section{\strong{Example} inline chips}{
\if{html}{\out{<div class="R">}}\preformatted{ui <- container(
  chipInput(
    id = "chips",
    choices = c(
      "A rather long option, isn't it?",
      "Shorter",
      "A middle-size option",
      "One more"
    ),
    values = 1:4,
    fill = FALSE
  ) \%>\%
    width("1/2") \%>\%
    background("blue") \%>\%
    shadow("small")
)

server <- function(input, output) \{

\}

shinyApp(ui, server)
}\if{html}{\out{</div>}}
}

\examples{

### Default input

chipInput(
  id = "chip1",
  choices = paste("Choice", 1:5),
  selected = c("Choice 3", "Choice 4")
)

}
\seealso{
Other inputs: 
\code{\link{buttonGroupInput}()},
\code{\link{buttonInput}()},
\code{\link{checkbarInput}()},
\code{\link{checkboxInput}()},
\code{\link{fileInput}()},
\code{\link{formInput}()},
\code{\link{listGroupInput}()},
\code{\link{menuInput}()},
\code{\link{navInput}()},
\code{\link{radioInput}()},
\code{\link{radiobarInput}()},
\code{\link{rangeInput}()},
\code{\link{selectInput}()},
\code{\link{textInput}()}
}
\concept{inputs}
