% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lassie.R
\name{write.lassie}
\alias{write.lassie}
\title{Write a lassie object}
\usage{
write.lassie(x, file, sep = ",", dec = ".", col.names = TRUE,
  row.names = FALSE, quote = TRUE, ...)
}
\arguments{
\item{x}{\code{\link[zebu]{lassie}} S3 object.}

\item{file}{character string naming a file.}

\item{sep}{the field separator string.  Values within each row of
    \code{x} are separated by this string.}

\item{dec}{the string to use for decimal points in numeric or complex
    columns: must be a single character.}

\item{col.names}{either a logical value indicating whether the column
    names of \code{x} are to be written along with \code{x}, or a
    character vector of column names to be written.  See the section on
    \sQuote{CSV files} for the meaning of \code{col.names = NA}.}

\item{row.names}{either a logical value indicating whether the row
    names of \code{x} are to be written along with \code{x}, or a
    character vector of row names to be written.}

\item{quote}{a logical value (\code{TRUE} or \code{FALSE}) or a
    numeric vector.  If \code{TRUE}, any character or factor columns
    will be surrounded by double quotes.  If a numeric vector, its
    elements are taken as the indices of columns to quote.  In both
    cases, row and column names are quoted if they are written.  If
    \code{FALSE}, nothing is quoted.}

\item{...}{other arguments passed on to write.table.}
}
\description{
Writes \code{\link[zebu]{lassie}} object to a file in a table structured format.
}
\seealso{
\code{\link[zebu]{lassie}}, \code{\link[zebu]{permtest}}
}
