% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{na_omit_loon}
\alias{na_omit_loon}
\title{Helper function to remove NAs for loon plots}
\usage{
na_omit_loon(x, y = NULL, linkingKey = NULL, itemLabel = NULL)
}
\arguments{
\item{x}{The vector of x values (required)}

\item{y}{The vector of y values (optional) of the same length as x;
if NULL then it's ignored.}

\item{linkingKey}{The vector of keys used to define links between points,
of the same length as x; if NULL it will be 0:(length(x)-1).}

\item{itemLabel}{The vector of labels for the points,
of the same length as x; if NULL it will be constructed.}
}
\value{
A list(x, y, linkingKey, itemLabel) where any NA in x or y will
        have been omitted from all
}
\description{
Helper function to remove NAs for loon plots
}
\seealso{
Other graphical tools: \code{\link{l_ispace_config}},
  \code{\link{plot_region}}, \code{\link{vport}},
  \code{\link{zenarrow}}
}
\author{
R. W. Oldford
}
\concept{graphical tools}
