% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zfit_base_zfunction_zfitter.R
\name{zfunction}
\alias{zfunction}
\title{Create a pipe-friendly version of any function}
\usage{
zfunction(fun, x)
}
\arguments{
\item{fun}{The function to adapt. The name should not be quoted,
rather, the actual function should be passed (prefixed with package
if needed).}

\item{x}{The name of the argument that should be moved to the
front of the argument list . The name should not be quoted.}
}
\description{
\code{zfunction()} rearranges the arguments of any function moving the
specified argument to the front of the list, so that this argument
becomes the recipient of piping.

It returns a copy of the input function, that is completely
identical except for the order of the arguments.
}
\examples{

char_vector <- rownames(mtcars)

zgrep <- zfunction(grep, x)
grep("ll", char_vector, value=TRUE)
zgrep(char_vector, "ll", value=TRUE)

}
